/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <search.h>
#include <strings.h>

#include "sm.h"
#include "sm_err.h"

#define CURRENT 1
#define ALERT 2
#define CAN_ALERT 3


extern int longcmp();
extern char *optarg;
extern int optind;
extern int sm_current_value();
extern int sm_numsensors;         /* number of elements in sensors */
extern SENSOR *sm_sensorlookup();

/* globals */

int query_type = CURRENT;	/* type of query*/
int relation = SM_ALERTONCE | SM_ALERTINIT;
EVENT *eid;			/* event id returned by em for ALERT */



void notify(status,sensor,instance,m_value,type,eh)
int status;
char *sensor, *instance;
message *m_value;
int type;
EVENT *eh;

{
    int count;
    PTR value;

    if (eh != eid) {
	fprintf(stderr,"Spurious notify\n");
	return;
    }
    if (status)
	printf("Alert failed, status = %d\n", status);

    printf("%s/%s:  ",sensor,instance);
    value = NULL;
    type_unpack(type,m_value,SM_VALFLD,&value);
    type_fprint(stdout,type,value);
    printf("\n");
    msg_delete(m_value);
    if  (relation & SM_ALERTONCE) exit(0);

    if  (relation & SM_ALERTONCE) exit(0);
}




main(argc,argv)
int argc;
char *argv[];

{
    static char *sdf = "sdf";
    static char *Useage = "Useage:  query\t [-H] [-I port] [-c class]\
[-f] [-t] [-m] [-p priority] [-s]\n\
\t\t sensor [instance] [relation value]\n";
    char * Help = "\n\Options:\n\
\t-H  Prints this message.\n\
\t-I  Use specified ISIS port\n\
The following options only apply for watches:\n\
\t-c  the class\n\
\t-f  notify failures\n\
\t-m  continually monitor for event.\n\
\t-p  the priority\n\
\t-s  stop on failure\n\
\t-t  require condition to go from false to true\n";


    SENSOR *sensors;                /* pointer to array of sensors */
    SENSOR *cp;			/* pointer to sensor of query */
    char *sensor;			/* sensor */
    char *instance;		        /* instance */
    char * firstperiod;
    int c,numargs;
    int status,type,num_elmts;
    int class = 0;
    int priority = 0;
    message *m_value;
    int  isisport;
    char *ipn;
    extern char * getenv();
    PTR value;
    
    ipn = getenv("ISISPORT");
    if (ipn) isisport = atoi(ipn);
    query_type = 0;
    while ((c = getopt(argc,argv,"I:Hc:d:fhmp:st")) != EOF) {
	if (c == 'd') {
	    query_type = CAN_ALERT;
	    eid = (EVENT *) atoi(optarg);
	} else if (c == 'm') {
            relation &= ~SM_ALERTONCE;
        } else if (c == 't') {
            relation &= ~SM_ALERTINIT;
        } else if (c == 'f') {
            relation |= SM_ALERTONFAIL;
        } else if (c == 's') {
            relation |= SM_STOPONFAIL;
        } else if (c == 'I') {
            isisport = atoi(optarg);
        } else if (c == 'p') {
            priority = atoi(optarg);
        } else if (c == 'c') {
            class = atoi(optarg);
	} else if ((c == 'H') || (c  == 'h')) {
	    printf(Useage);
	    printf(Help);
	    exit(0);
	} else {
	    fprintf(stderr,Useage);
	    exit(-1);
	}
    }

    numargs = argc  - optind;
    if (numargs) {
	sensor = argv[optind++];
    } else {
	fprintf(stderr,Useage);
	exit(-1);
    }

    if (numargs == 2) 
      sm_init1(isisport);	/* quick init if just polling */
    else
      sm_init(isisport);
    cp = sm_sensorlookup(sensor);

    if (!cp) {
	fprintf(stderr,"Unknown sensor %s\n",sensor);
	exit(-1);
    }

    if (numargs == 1) {
	instance = NULL;
	if (1 /* cp->mode != INTERRUPT */) {
	    fprintf(stderr,"Wrong type of sensor for this kind of query\n");
	    exit(-1);
	}
	if (query_type != CAN_ALERT) {
	    relation |= R_CHANGE;
	    query_type = ALERT;
	}
    } else if (numargs == 2) {
	instance = argv[optind];
	if (!query_type) {
	    /* if not a delete-condition, then what is it? */
	    if ( 0 /* cp->mode == INTERRUPT */) {
		relation |= R_CHANGE;
		query_type = ALERT;
	    } else {
		query_type = CURRENT;
	    }
	}
    } else if ((numargs > 4) || (numargs < 1)) {
	fprintf(stderr,Useage);
	exit(-1);
    } else {
        /* numargs = 3 or 4, so it is an ALERT */
        if (numargs == 3)
	  /* only sensor specified, await instance */
          instance = "*";
        else
          /* sensor and instance specified, await instance */
	  instance = argv[optind++];

	relation |= type_relop(argv[optind++]);
	query_type = ALERT;
	if (relation & R_CARD) {
	    if (cp->type & TYPE_SET)
	      type = TYPE_INT;
	    else
	      type = cp->type & TYPE_BASE;
	} else
	  type = cp->type;

	ascii_to_type(type,argv[optind],NULL,&value);
        printf("await value is ");
        type_fprint(stdout,type,value);
        printf("\n");
    }

    printf("Querying sensor manager for (%s,%s)\n",sensor,instance);

    if (query_type == CURRENT) {
        int count;

	status = sm_current_value(sensor,instance,
				  &m_value,&type);
	printf("%s/%s:  ",sensor,instance);
	if (status) {
	    fprintf(stderr,"Error %d in getting value\n",status);
        }
        if (status != SM_NOTKNOWN) {
            if (status) 
                printf("default value:  ");
	    value = NULL;
	    type_unpack(type,m_value,SM_VALFLD,&value);
	    type_fprint(stdout,type,value);
	    printf("\n");
        }
	exit(0);
    } else if (query_type == ALERT) {
	m_value = msg_newmsg();
	type_pack(type,m_value,SM_VALFLD,value);
	status = sm_watch(sensor,instance,relation,
	         	  m_value,notify,priority,class,&eid);
 	if (status) {
	    fprintf(stderr,"Alert failed, status = %d\n",status);
	    if (status != SM_NOTAVAIL)
              exit(-1);
        }
	printf("received eid %d\n",(unsigned int) eid);
	isis_accept_events(ISIS_BLOCK);
	isis_mainloop(0);
    } else if (query_type == CAN_ALERT) {
	status = sm_stop_watch(eid);
	if (status) {
	    fprintf(stderr,"Cancel-alert failed, status = %d\n",
		    status);
	    exit(-1);
	}
    }
}

