/*

Copyright 1990 by K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/


/* load_tables.c

Contains tut_load_tables.

NOTE that tut_load_tables prints progress messages to stdout, thus
limiting its utility.

*/
#include <stdio.h>
#include <strings.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_client.h"
#include "tutil.h"

int tut_load_tables(file)
char *file;
{
    FILE *in;
    char relation[TBL_MAXNAME], attrs[TUT_MAXSTRING], tuples[TUT_MAXSTRING];
    int count, replicas, v, v1;
    
    printf("Loading tables described in %s.\n", file);
    in = fopen(file, "r");
    if (!in) return TUT_OPEN_FAILED;
    
    while (TRUE) {
        count = fscanf(in, "%s %d %s %s", relation, &replicas, attrs, tuples);
        if (count == EOF) return CloseAndReturn(in, TBL_SUCCESS);
        if (count != 4) return CloseAndReturn(in, TUT_BAD_FORMAT);

	if (v == TBL_FAILURE) return CloseAndReturn(in, v);

        v = tut_load_attr(relation, FALSE, replicas, FALSE, attrs);
        if (v != TBL_SUCCESS && v != TBL_TABLE_EXIST) {
	    return CloseAndReturn(in, v); }
        if (v == TBL_TABLE_EXIST)
             printf("%s already exists.\n", relation);
        else printf("%s created, replication %d.\n", relation, replicas);

        v = tut_load_tuples(relation, &count, tuples, TRUE);
        if (v != TBL_SUCCESS && v != TBL_TUPLE_DUPLICATE) return CloseAndReturn(in, v);
        if (v == TBL_TUPLE_DUPLICATE)
             printf("Duplicate tuple found while loading %s; loading not done.\n", relation);
        else printf("%s loaded with %d tuples.\n", relation, count);
    }
}

int CloseAndReturn(f, v)
FILE *f;
int v;
{
    fclose(f);
    return v;
}
