/*

Copyright 1990 by K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "table.h"
#include "tutil.h"
#include "types.h"

int tut_dump_attr(relation, filename, open_type)
RELNAME relation;		/* name of relation			*/
char	*filename, *open_type;
{
  FILE *out;
  int	num_attributes;		/* number of attributes 		*/
  AttDes  *attributes, *a;	/* attributes information 		*/
  int i, n, v;
  TableInfo info;

  v = t_info(relation, &info,&attributes);
  if (v != TBL_SUCCESS) return v;

  out = fopen(filename, open_type);
  if (!out) return TUT_OPEN_FAILED;

  for(i = 0; i < info.num_attr; i++) {

	a = &attributes[i];
	fprintf(out, "%s %s %d\n",
		a->AttName, type_to_name(a->type), a->clientData);
  }
  fclose(out);
  return TBL_SUCCESS;
}
