/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_client.h"
#include "table_lib.h"

int t_startenum(relation, column_num, filter, info, attr, state)
RELNAME relation;		/* name of relation */

int column_num;			/* column (attribute) number to sort by	  */
				/* TBL_NOSORT means order is unimportant  */
				/* TBL_SORTALL means sort lexigraphically */
				/* on all columns			  */

message *filter;		/* filter on tuples returned		  */
				/* list of triples (conjunction):	  */
				/*	column number to compare,	  */
				/*	value to compare,		  */
				/*	sense of comparison		  */

TableInfo *info;		/* output: current table info 		  */
AttDes **attr;			/* output: table schema 		  */

struct state **state;		/* output: ptr to enumeration state struct */

{
  int v;

  *state = (struct state *)malloc(sizeof(struct state));
  v = t_list(relation, column_num, filter, 
  	info, attr, &((*state)->array));
  if (v != TBL_SUCCESS) return v;

  strncpy((*state)->relation, relation, sizeof(RELNAME));
  (*state)->info = *info;
  (*state)->index = 0;
  return v;
}
