/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <search.h>
#include <strings.h>
#include "isis_errno.h"
#include "sm.h"
#include "sm_err.h"
#include "classes.h"
#include "meta_entries.h"


  /*  The sensor monitor/manager library - condition watching.
      Implements functions sm_watch and sm_stopwatch along
      with supporting routines.

      By Mark D. Wood.
   */


/* external function declarations */

extern char *strdup();

/* library globals */

extern int sm_numsensors;       /* number of elements in sensors */
extern int sm_watching;
extern message *empty_message;	/* empty isis message constant */
extern message *empty_set;	
extern SENSOR *sm_sensors;      /* pointer to array of sensor info */
extern address *sm_sensor_address();
extern int sm_clientof[MAX_NUM_CLASSES]; 
extern SENSOR *sm_sensorlookup();
extern char *class_name[MAX_NUM_CLASSES];
extern void sensor_failed();
extern EVENT * sm_eventlist;
extern OCCURRENCE *waiting_q;
extern void bypass_enable();

void sm_alert();


#ifdef DEBUG
event_chk_consistency(s)
char *s;

{
    EVENT *e,*next;

    fprintf(stderr,"%s\n",s);

    for (e = sm_eventlist; e; e=next) {
	next = e->next;
	if (((((int) e->prev) && (int) e->prev < 4096)) ||
	    ((((int) e->next) && (int) e->next < 4096)) ||
	    (e->priority != 0) ||
/*	    (e->class != (int) e) || */
	    (e->relation > 4096) ||
	    (e->num_running > 1) ||
	    (e->num_running < 0) ||
	    (e->delete > 1)) {
	    fprintf(stderr,"bad things have happened\n");
	}
    }
}
#endif


int sm_watch(sensor,instance,relation,m_value,func,priority,class,eid)
char *sensor;
char *instance;
int relation;
message *m_value;
void (*func)();
int priority;
int class;
EVENT **eid;

{
    SENSOR *sp;
    address *gaddr;

    sp = sm_sensorlookup(sensor);
    if (sp == NULL)
      return SM_NOTKNOWN;

    if (!instance)
      instance = "*";

    gaddr = sm_sensor_address(sp->class,instance);

    if ((relation & SM_STOPONFAIL & ~SM_ALERTONFAIL)
	&& addr_isnull(gaddr)) {
        return SM_NOTAVAIL;
    }

    if (strlen(instance) >= INSTANCE_LENGTH)
      return SM_NAMETOOLONG;

    if (!m_value) {
	if (sp->type & TYPE_SET) {
	    m_value = empty_set;
	    msg_increfcount(empty_set);
	} else {
	    m_value = sp->default_val;
	    msg_increfcount(sp->default_val);
	    msg_rewind(sp->default_val);
	}
    }

    *eid = (EVENT *) malloc(sizeof(EVENT));
    if (!*eid)
      return SM_INTERNAL;

#ifdef DEBUG
    printf("assigning eid %d\n",(int) *eid);
#endif

    (*eid)->priority = priority;
    (*eid)->class = (class) ? class : (unsigned) *eid;
    (*eid)->relation = relation;
    (*eid)->sp = sp;
    (*eid)->instance = strdup(instance);
    (*eid)->func = func;
    (*eid)->sn_addr = *gaddr;
    (*eid)->waiting = NULL;
    (*eid)->delete = FALSE;
    (*eid)->num_running = 0;
    (*eid)->await_val = m_value;
    (*eid)->variety = META_SENSOR;
    msg_increfcount(m_value);
    el_insert(&sm_eventlist,*eid);

    if (!addr_isnull(gaddr)) {
	if ((!sm_clientof[sp->class]) &&
	    (relation & SM_ALERTONFAIL)) {
	    address * caddr;
	    caddr = sm_sensor_address(sp->class,NULL);
	    pg_client(caddr,"");
	    if (pg_monitor(caddr,sensor_failed,0) > 0)
	      sm_clientof[sp->class] = TRUE;
	}

	if (!(relation & SM_ALERTONCE))
	  bypass_enable(sp->class);

	if (cbcast(gaddr,SN_ALERT,
		   "%s%s%d%d%m",
		   sp->name,instance,(unsigned)*eid,
		   relation,m_value,0)< 0){
	    if ((isis_errno == IE_UNKNOWN)) {
		return SM_NOTAVAIL;
	    } else {
		isis_perror("sm_watch");
		return SM_INTERNAL;
	    }
	}
#ifdef DEBUG
	printf("watch %d on %s set\n",*eid,instance);
#endif
    } else if (relation & SM_ALERTONFAIL) {
	return SM_NOTAVAIL;
    }
/*  addr_free(gaddr); */
    return 0;
}



int sm_stop_watch(eid)
EVENT *eid;

{
    OCCURRENCE *op,*next;
    int status = 0;

    /* NOTE - it's a gbcast */

/*    flush(); */

    if (gbcast(&eid->sn_addr,SN_CANALERT,
	       "%s%s%d",
	       eid->sp->name,eid->instance,(unsigned int) eid,
	       ALL,"") <0) {
	isis_perror("sm_stop_watch");
	status = SM_INTERNAL;
    }

#ifdef DEBUG
    printf("gbcast cancelled %d\n",eid);
#endif

    /* now guaranteed that this event can no longer occur */
    
    if (!eid->delete) {
	for (op = eid->waiting; op; op = next) {
	    next = op->next_waiting;
	    pq_delete(&waiting_q,op);
	    free((char *)op);
	}
    }

    if (eid->num_running)
      eid->delete = TRUE;
    else if (!eid->delete) {
	el_delete(&sm_eventlist,eid);
	free_event(eid);
    }
    return status;
}



