/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include "sm.h"

/* queue insertion and deletion operators for the different queues
   maintained.  The pq routines are for the priority queue; the others
   are general queues; separate routines are provided instead of a
   single abstract data type because the same structure is involved
   in both types of queues and we wanted to minimize the number of
   pointers.

   By Mark D. Wood
*/


/* The priority queues are implemented as circularly linked lists */


pq_insert(queue,element)
OCCURRENCE ** queue, *element;

{
    OCCURRENCE *p;

    if (*queue == NULL) {
	*queue = element;
	element -> next = element -> prev = element;
    } else {
	/* start at rear of queue, looking for first job with
	   higher priority; insert after that element.  Provides
	   FCFS within those of same priority. */
	for (p = (*queue) -> prev;
	     p != (*queue) && (p->priority >= element->priority);
	     p = p -> prev)
	  ;
	/* insert new element after p */
	(p->next)->prev = element;
	element->prev = p;
	element->next = p->next;
	p->next = element;
	if ((p == *queue) && (element->priority > p->priority))
	  *queue = p;
    }
}
	

pq_delete(queue,element)
OCCURRENCE ** queue, *element;

{
    (element->prev)->next = element->next;
    (element->next)->prev = element->prev;
    if (*queue == element)
      *queue = (element->next == element) ? NULL : element->next;
}



/* The waiting queues are noncircular queues; each end is terminated
   with a null pointer */


wq_insert(queue,element)
OCCURRENCE **queue, *element;

{
    element -> prev_waiting = NULL;
    element -> next_waiting = (*queue);
    if ((*queue))
      (*queue) -> prev_waiting = element;
    (*queue) = element;
}



wq_delete(queue,element)
OCCURRENCE **queue,*element;

{
    if (element->next_waiting)
      element->next_waiting->prev_waiting = element->prev_waiting;
    if (element->prev_waiting)
      element->prev_waiting->next_waiting = element->next_waiting;
    if (*queue == element)
      *queue = element->next_waiting;
}




/* The event lists are noncircular doubly-linked lists; each end is
   terminated with a null pointer */


el_insert(queue,element)
EVENT **queue, *element;

{
    element -> prev = NULL;
    element -> next = (*queue);
    if ((*queue))
      (*queue) -> prev = element;
    (*queue) = element;
}



el_delete(queue,element)
EVENT **queue,*element;

{
    if (element->next)
      element->next->prev = element->prev;
    if (element->prev)
      element->prev->next = element->next;
    if (*queue == element)
      *queue = element->next;
}
