/* parse getcif file

   By Wanda Chiu
   Revised 13-Oct-89 mdw
*/


#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#include "classes.h"
#include "sm.h"

extern int sm_numclasses;
extern char *strdup();


typedef struct instance
{
     char *instname;
     struct instance *next_inst;
};     

 
Get_Name(outbuf, size,  bufp)
char *outbuf;
int size;
char **bufp;

{
    int num_read;
    int num_wanted;
    while(isspace(**bufp))
      (*bufp)++;
    if(**bufp == '\n')
       return 0;
    if(**bufp == '#')
       return -1;
    size--;
    num_wanted = size;
    num_read  = 0;
    do
    {
       if(size)
       {
         *outbuf++ = *(*bufp)++; 
         size--; 
       }
       else
         (*bufp)++;
       num_read++;
       
    }
    while(**bufp != '\n' && !(isspace(**bufp)) && **bufp != '#');
    *outbuf = '\0';
    if(num_read  > num_wanted)
      return -1;
    return 1; 
     
}
          

CLASS_INST *sm_getcif(filename)
char *filename;
{
    static CLASS_INST *classes = NULL;
    static struct instance *class_buf[MAX_NUM_CLASSES];
    struct instance *instances,*prev_inst, *newinst;
    static int num_instances[MAX_NUM_CLASSES];  
    char classname[INSTANCE_LENGTH], instancename[INSTANCE_LENGTH];
    int classnum; 
    char buffer[90],*bufp;
    FILE *fh;
    int line;
    int retcode;
    int compval;
    int i;
    
    if (classes) return classes; /* don't do if already called */

    if((fh = fopen(filename, "r")) == NULL) 
    {
       fprintf(stderr,"sm_getcif: error in opening %s.\n",filename); 
       exit(-1);
    }
    line = 0;
    while(fgets(buffer, sizeof(buffer), fh))
    {
        bufp = buffer; line++;
        if((*bufp == '#')  || (*bufp == '\n'))
           continue;
        if((retcode = Get_Name(classname, sizeof(classname),&bufp))< 0) 
        {
           fprintf(stderr, "sm_getcif: Bad class name, line %d \n",line);
           continue;
        }
        else if(retcode == 0)
            continue;
     
	if ((classnum = class_lookup(classname)) <0) {
	    if (sm_numclasses == MAX_NUM_CLASSES) {
		perror("Internal class table overflow!\n");
		exit(-1);
	    } else {
		classnum = sm_numclasses++;
		class_name[classnum] = strdup(classname);
	    }
	}

        if((retcode = Get_Name(instancename, 
                               sizeof(instancename), &bufp)) ==  0)
        {
          fprintf(stderr, "sm_getcif: No instance specified for %s, line %d\n",
                  classname, line);
          continue;
        }
        do
        {
            if(retcode ==  -1)
            {
               fprintf(stderr, "sm_getcif: Bad input \n");      
               continue;
            }
            instances = class_buf[classnum];
            prev_inst = NULL;
            compval = -1;
            while(instances != NULL && 
                  (compval = strcmp(instancename, instances->instname)) > 0)
           {
             prev_inst = instances;
             instances = instances->next_inst;
           }
           if(compval == 0)
           {
              fprintf(stderr,
                      "sm_getcif: Duplicate Instance %s is ignored, line %d\n",
                      instancename, line); 
              continue;
           }
           if((newinst = 
              (struct instance *) malloc(sizeof(struct instance))) == NULL) 
           {
              perror("sm_getcif - error in malloc");
              exit(-1);
           }
           if((newinst->instname = malloc(strlen(instancename) + 1)) == NULL)
           {
              perror("sm_getcif - error in malloc");
              exit(-1);
           }
           strcpy(newinst->instname, instancename);
           newinst->next_inst = instances;
           if(prev_inst == NULL) 
              class_buf[classnum] = newinst;
           else
              prev_inst->next_inst = newinst; 
           num_instances[classnum]++;
       }
       while(*bufp != '\n' && 
             (retcode = Get_Name(instancename, sizeof(instancename),
                                 &bufp)) != 0);
      
    }
    if((classes =  (CLASS_INST *)calloc(MAX_NUM_CLASSES, 
                                       sizeof(CLASS_INST))) == NULL)
    {
        perror("sm_getcif -  error in calloc");
        exit(-1); 
    }

    for(classnum = 0; classnum< MAX_NUM_CLASSES; classnum++)
    {
       if((classes[classnum].num_instances = num_instances[classnum]) != 0)
       {  
          if((classes[classnum].instances = 
                    (char **)calloc(num_instances[classnum],
                                    sizeof(char *))) == NULL)

          {
             perror("sm_getcif - error in calloc");
             exit(-1);
          }
          instances = class_buf[classnum]; 
          prev_inst = NULL;
          for(i = 0; i < num_instances[classnum]; i++)
          {
             classes[classnum].instances[i] = instances->instname;
             prev_inst = instances;
             instances  = instances->next_inst;        
             free(prev_inst);
          }
       }
       else
          classes[classnum].instances = NULL;
    }
    return classes;
}



