/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include "sm.h"
#include "sm_err.h"
#include "meta_entries.h"

/* library globals */

extern int sm_numsensors;
extern SENSOR *sm_sensors;
extern address *sm_sensor_address();
extern int strcmp();


int sm_actuate(actuator,instance,m_value,block)
char *actuator;                 /* in: name of actuator */
char *instance;                 /* in: specific instance */
message *m_value;               /* in: value */
int block;			/* in: do we block for reply? */
{
    address *gaddr;
    int status[MAX_PROCS];
    SENSOR *sp;
    int nr;
    extern SENSOR * sm_sensorlookup();

#ifdef DOTHIS
    sp = (SENSOR *) bsearch(actuator,(char *) sm_sensors,sm_numsensors,
                            sizeof(SENSOR),strcmp);
#endif

    sp = sm_sensorlookup(actuator);
    if (!sp)
      return SM_NOTKNOWN;

    gaddr = sm_sensor_address(sp->class,instance);

    if (addr_isnull(gaddr)) {
        return SM_NOTAVAIL;
    }

    if (block) {
	nr = cbcast(gaddr,SM_ACT,"%s%m%d",sp->name,m_value,ACT_SYNC,
		    ALL,"%d",status);
	if (!nr) return SM_NOTAVAIL;
	else if (nr < 0) return SM_INTERNAL;
	else return 0;
    } else {
	if (cbcast(gaddr,SM_ACT,"%s%m%d",sp->name,m_value,ACT_SYNC,0)
	    < 0) return SM_INTERNAL;
	else return 0;
    }
}


