/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

By Mark D. Wood

*/

#include "sm.h"
#include "sm_err.h"
#include "meta_entries.h"

/* library globals */

extern int sm_numsensors;
extern SENSOR *sm_sensors;
extern address *sm_sensor_address();
extern EVENT * sm_eventlist;

extern int strcmp();
extern char * strdup();

int sm_async_actuate(actuator,instance,m_value,func,priority,class,uid)
char *actuator;                 /* in: name of actuator */
char *instance;                 /* in: specific instance */
message *m_value;               /* in: value */
void (*func)();			/* in: function to call */
int priority;			/* in: scheduling priority */
int class;			/* in: scheduling class */
long uid;			/* in: id to return to client */

{
    address *gaddr;
    SENSOR *sp;
    int nr;
    extern SENSOR * sm_sensorlookup();
    EVENT *eid;

    sp = sm_sensorlookup(actuator);
    if (!sp)
      return SM_NOTKNOWN;

    gaddr = sm_sensor_address(sp->class,instance);

    if (addr_isnull(gaddr)) {
        return SM_NOTAVAIL;
    }

    
    eid = (EVENT *) malloc(sizeof(EVENT));
    if (!eid)
      return SM_INTERNAL;

#ifdef DEBUG
    printf("assigning eid %d\n",(int) eid);
#endif

    eid->variety = META_ACTUATOR;
    eid->uid = uid;
    eid->priority = priority;
    eid->class = (class) ? class : (unsigned) eid;
    eid->sp = sp;
    eid->instance = strdup(instance);
    eid->func = func;
    eid->sn_addr = *gaddr;
    eid->waiting = NULL;
    eid->delete = FALSE;
    eid->num_running = 0;
    eid->await_val = m_value;
    eid->relation = SM_ALERTONFAIL; /* may wish have this as option */
    msg_increfcount(m_value);
    el_insert(&sm_eventlist,eid);

    nr = cbcast(gaddr,SM_ACT,"%s%m%d%d",
		sp->name,m_value,ACT_ASYNC,eid,0);
    if (!nr) return SM_NOTAVAIL;
    else if (nr < 0) return SM_INTERNAL;
    else return 0;

}

/* what should we do when an actuator fail?

   Might want to reload its conditions

   Have ability to report failure

   could have version that sets eid->nr to nsent; don't do notify
   until hear from all.  But failures...

*/

