/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include <stdio.h>

int width, height;

do_line(){
	int x1, y1, x2, y2;

	scanf("%d %d %d %d\n", &x1, &y1, &x2, &y2);
	printf("line from (%d, %d) to (%d, %d)\n", x1, height - y1,
							x2, height - y2);
}

do_circle(){
	int x, y, w, h;

	scanf("%d %d %d %d\n", &x, &y, &w, &h);
	printf("ellipse wid %d ht %d at (%d, %d)\n", w, h,
					x + w / 2, height - y - h / 2);
}

do_string(){
	int x, y, w, h;
	char fmt[16], buf[128];

	scanf("%d %d %d %d %s ", &x, &y, &w, &h, fmt);
	gets(buf);
	y = height - y + h / 2;
	switch (*fmt) {
	case 'l':
		printf("\"%s\" at (%d, %d) ljust\n", buf, x, y);
		break;
	case 'c':
		printf("\"%s\" at (%d, %d) center\n",
					buf, x + w / 2, y);
		break;
	case 'r':
		printf("\"%s\" at (%d, %d) rjust\n",
					buf, x + w, y);
	default:
		fprintf(stderr, "bad format in string\n");
	}
}

do_rectangle(){
	int x, y, w, h;

	scanf("%d %d %d %d\n", &x, &y, &w, &h);
	y = height - y;
	printf("\"\\s25\"\n");
	printf("line from (%d, %d) to (%d, %d) to (%d, %d) to (%d, %d) to (%d, %d)\n",
		x, y, x + w, y, x + w, y - h, x, y - h, x, y);
	printf("\"\\s0\"\n");
}

do_poly(){
	int n, x1, y1, x2, y2;

	scanf("%d %d %d", &n, &x1, &y1);
	printf("line from (%d, %d)", x1, height - y1);
	while (--n) {
		scanf(" %d %d", &x2, &y2);
		printf(" to (%d, %d)", x2, height - y2);
	}
	printf(" to (%d, %d)\n", x1, height - y1);
	getchar();
}

main(){
	int type;

	scanf("%d %d\n", &width, &height);
	while ((type = getchar()) != EOF) {
		getchar();
		switch (type) {
		case 'l':	do_line();	break;
		case 'c':	do_circle();	break;
		case 's':	do_string();	break;
		case 'r':	do_rectangle();	break;
		case 'p':	do_poly();	break;
		default:
			fprintf(stderr, "format error\n");
			exit(1);
		}
	}
}
