/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#define NSIGPRO		3

struct sigpro {
	int burst;
	long timer;
} sigpro[NSIGPRO];

sig_rand(n){
	return random() % (n * 2) - n;
}

sig_message(){
	long time(), now;
	char buf[16];
	struct sigpro *s;

	time(&now);
	db_numstore("clock", "value", (int) now);
	for (s = sigpro; s < &sigpro[NSIGPRO]; s++) {
		mag_strnum(buf, s - sigpro);
		if (s->burst) {
			db_numstore("sigpro", buf, sig_rand(s->burst));
			if (now >= s->timer) {
				s->burst = 0;
				s->timer = now + 10 + random() % 20;
				db_numstore("load", buf, 5);
			}
		}
		else {
			db_numstore("sigpro", buf, sig_rand(5));
			if (now >= s->timer) {
				s->burst = random() % 40 + 10;
				s->timer = now + 5 + random() % 5;
				db_numstore("load", buf, s->burst);
			}
		}
	}
}

main(){
	mag_init("sigpro");
	sig_message();
	win_receive(sig_message);
	if (fork() == 0)
		for (;;) {
			if (getppid() < 2)
				_exit(0);
			win_message();
			sleep(1);
		}

	win_main_loop();
	mag_exit(0);
}
