/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"

#define MAXJOBS		 10
#define MAXLOAD		 10
#define INTERVAL	300

main(argc, argv)
char **argv;
{
	int i;
	char *wid, *pic_new(), *mag_new(), buf[128];

	mag_cold(argv[1], 400, 400, 1);

	wid = pic_new("widget", "container", "menu", 17, 5, 25, 25, 1, 1);
	db_numstore(wid, "interval", 1);
	db_store(wid, "attr", "mapped");
	MAG_FREE(wid);

	wid = pic_new("widget", "graph", "proctab", 150, 10, 80, 50, 1, 0);
	db_numstore(wid, "interval", INTERVAL);
	db_numstore(wid, "min", 0);
	db_numstore(wid, "max", MAXJOBS + 1);
	db_store(wid, "attr", "load");
	MAG_FREE(wid);

	MAG_FREE(pic_new("widget", "picture", "lines", 250, 10, 80, 50, 0, 0));
	for (i = 0; i < MAXLOAD; i++) {
		wid = pic_new("lines", "line", (char *) 0, 0, 0, 8192, 0, 0, 0);
		sprintf(buf, "#%d 8192 * lines N # /", i);
		db_store(wid, "y", buf);
	}
	sprintf(buf, "# machine load %d std.func max # $eval $ceil", INTERVAL);
	db_store("lines", "N", buf);

	wid = pic_new("widget", "graph", "machine", 250, 10, 80, 50, 1, 0);
	db_numstore(wid, "interval", INTERVAL);
	db_numstore(wid, "min", 0);
	db_store(wid, "max", "#lines N #");
	db_store(wid, "attr", "load");
	db_store(wid, "fill", "black");
	MAG_FREE(wid);

	mag_clock();
	MAG_FREE(pic_new("widget", "picture", "clock", 345, 5, 50, 50, 0, 0));

	for (i = 0; i < MAXJOBS; i++)
		MAG_FREE(mag_new("proctab"));
	wid = pic_new("widget", "table", "proctab", 22, 100, 368, 250, 1, 1);
	tbl_column(wid, "cmd", 1, 4, "l", "ro");
	MAG_FREE(wid);

	watch_cold("clock", "update", "clock", "value");

	mag_exit(0);
}
