/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This function sends a message to a station and prints the reply.  The
 * syntax is "magic destination message ...".
 */

#include "magic.h"
#include "value.h"

reply(station, m)
struct value *station, **m;
{
	if (m == 0)
		printf("destination %s unavailable\n", val_str(station));
	else {
		printf("got reply from %s\n", val_str(station));
		mes_print(m);
	}
	db_store("control", "status", "stop");
}

main(argc, argv)
char *argv[];
{
	char **v;
	struct value **req, **mes_alloc();
	int i = 1, mag_term();

	mag_cold("magic", 100, 100, 0);
	win_init();
	com_init();
	db_store("control", "status", "run");
	mes_subscribe("mag_term", mag_term);
	watch_specify(V_NULL, "mag_term", "control", "status");
	req = mes_alloc(argc);
	v = &argv[2];
	while (*v != 0)
		req[i++] = val_sstr(*v++, 0);
	mes_send_request(val_sstr(argv[1], 0), req, reply);
	win_main_loop();
	mag_exit(1);
}
