/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include <math.h>
#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

#define PI		3.1415927

char *pic_new();

/* Create a line widget.
 */
line_append(name, x1, y1, x2, y2)
char *name;
{
	MAG_FREE(pic_new(name, "line", (char *) 0,
					x1, y1, x2 - x1, y2 - y1, 0, 0));
}

/* Draw a line widget.
 */
line_draw(w, o)
struct window *w;
struct object *o;
{
	win_line(w, o->o_x, o->o_y, o->o_x + o->o_width, o->o_y + o->o_height);
}

/* Draw an arrow widget.
 */
arrow_draw(w, o)
struct window *w;
struct object *o;
{
	double alpha = 64 * 35, r = 8, beta, s, c;
	int xa, ya, xb, yb, x2, y2;

	x2 = o->o_x + o->o_width;
	y2 = o->o_y + o->o_height;
	win_line(w, o->o_x, o->o_y, x2, y2);
	beta = atan2((double) o->o_height, (double) o->o_width);
	sincos(beta + alpha * PI / (64 * 180), &s, &c);
	xa = x2 - r * c;
	ya = y2 - r * s;
	win_line(w, xa, ya, x2, y2);
	sincos(beta - alpha * PI / (64 * 180), &s, &c);
	xb = x2 - r * c;
	yb = y2 - r * s;
	win_line(w, xb, yb, x2, y2);
}

/* Draw a circle.
 */
circle_draw(w, o)
struct window *w;
struct object *o;
{
	win_circle(w,	m_min(o->o_x, o->o_x + o->o_width),
			m_min(o->o_y, o->o_y + o->o_height),
			m_abs(o->o_width), m_abs(o->o_height));
}

/* Draw a hand widget.
 */
hand_draw(w, o)
struct window *w;
struct object *o;
{
	double thickness, angle, c, s;
	int w1, w2;
	XPoint p[3];

	db_dblretrieve(o->o_name, "thickness", &thickness);
	thickness *= hypot((double) o->o_width, (double) o->o_height) / 2;
	angle = atan2((double) o->o_height, (double) o->o_width);
	sincos(angle, &s, &c);
	w1 = irint(thickness * (c - s));
	w2 = irint(thickness * (c + s));
	p[0].x = o->o_x - w1;		p[0].y = o->o_y - w2;
	p[1].x = o->o_x + o->o_width;	p[1].y = o->o_y + o->o_height;
	p[2].x = o->o_x - w2;		p[2].y = o->o_y + w1;
	win_fillpoly(w, p, 3);
}
