/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

#define WIDTH		450
#define HEIGHT		150

char *mag_new(), *pic_new();
struct value **mes_ok(), **mes_alloc(), *db_get();

ww_reply(station, rep)
struct value *station, **rep;
{
	if (rep == 0)
		db_store("watch.err", "text", "destination unavailable");
	else {
		db_store("watch.err", "text", "fill in table");
		db_numstore("watch", "mapped", 0);
	}
}

struct value **ww_select(req)
struct value **req;
{
	extern db_seq;
	struct value **mes;

	if (val_null(req[5]))
		return mes_ok();
	mes = mes_alloc(5);
	mes[1] = val_sstr("watch", db_seq);
	mes[2] = db_get("watch.admin", "cmd", db_seq);
	mes[3] = db_get("watch.admin", "record", db_seq);
	mes[4] = db_get("watch.admin", "attr", db_seq);
	mes_send_request(db_get("watch.admin", "dest", db_seq), mes, ww_reply);
	db_store("watch.sel", "select", (char *) 0);
	return mes_ok();
}

ww_init(){
	char *wid;

	mag_picture("watch.win", "watch", "watch", WIDTH, HEIGHT, 0);

	wid = mag_new("watch.tab");
	db_store(wid, "dest", "destination");
	db_store(wid, "cmd", "command");
	db_store(wid, "record", "record");
	db_store(wid, "attr", "attribute");
	MAG_FREE(wid);
	mag_append("watch.tab", "watch.admin", 0);
	wid = pic_new("watch", "table", "watch.tab",
					10, 10, WIDTH - 20, 50, 1, 1);
	tbl_column(wid, "dest", 1, 0, "c", (char *) 0);
	tbl_column(wid, "cmd", 1, 0, "c", (char *) 0);
	tbl_column(wid, "record", 1, 0, "c", (char *) 0);
	tbl_column(wid, "attr", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	MAG_FREE(pic_new("watch", "menu", "watch.sel", 10, 75, 40, 40, 1, 1));
	db_numstore("watch.sel", "N", 1);

	mag_append("watch.output", "watch.err", 0);
	db_store("watch.err", "text", "fill in table");
	wid = pic_new("watch", "table", "watch.output",
					60, 75, WIDTH - 70, 40, 1, 1);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
}

ww_start(){
	mes_subscribe("ww_select", ww_select);
	watch_specify(V_NULL, "ww_select", "watch.sel", "select");
}
