/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * Create a set of records according to some template.  The template consists
 * of records whose names start with @.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

#define WIDTH		450
#define HEIGHT		150

char *mag_new(), *pic_new();
struct value **mes_ok(), *mag_index();

/* name is a template record.  Create a new record, and return its name in
 * new.  Copy each attribute in the template record.  Each attribute whose
 * value starts with a '@' is a new record to be created according to the
 * template named by the value.  So this routine is recursive.  New names
 * are generated by an "_" followed by @template#uniq.  #template#uniq is
 * increased each time.  The variable "@" is assigned vars itself.
 */
temp_stamp(name, vars)
char *name, *vars;
{
	int i, uniq, N;
	struct value *v_attr;
	char new[32], buf[64], *attr, *value, *var;

	db_retrieve(vars, name, &var);
	if (var != 0) {
		MAG_FREE(var);
		return;
	}
	db_numretrieve("@template", "uniq", &uniq);
	sprintf(new, "_%d", uniq);
	db_store(vars, name, new);
	db_numstore("@template", "uniq", ++uniq);
	db_store("@template", "record", name);
	db_numretrieve("@template", "N", &N);
	sprintf(buf, "#%s $attr #", name);
	db_store(new, "$default", buf);
	for (i = 1; i < N; i++) {
		db_store("@template", "record", name);
		v_attr = mag_index("@template", i);
		if ((attr = val_str(v_attr)) != 0) {
			db_retrieve(name, attr, &value);
			if (*value == '@')
				if (value[1] == 0)
					db_store(new, attr, vars);
				else {
					temp_stamp(value, vars);
					db_retrieve(vars, value, &var);
					db_store(new, attr, var);
					MAG_FREE(var);
				}
			else
				db_store(new, attr, value);
			MAG_FREE(value);
		}
		val_free(v_attr);
	}
}

struct value **temp_select(req)
struct value **req;
{
	char *rec, *vars;

	if (val_null(req[4]))
		return mes_ok();
	db_retrieve("temp.sel", "answer", &rec);
	db_retrieve("temp.vars", "answer", &vars);
	if (rec == 0 || vars == 0) {
		db_store("temp.sel", "error", "fill in all of table");
		MAG_FREE(rec);
		MAG_FREE(vars);
	}
	else {
		if (*rec != '@')
			db_store("temp.sel", "error",
					 "record must start with '@'");
		else {
			db_store("temp.sel", "error", (char *) 0);
			temp_stamp(rec, vars);
			db_numstore("template", "mapped", 0);
		}
		MAG_FREE(rec);
		MAG_FREE(vars);
	}
	db_store("temp.sel", "select", (char *) 0);
	return mes_ok();
}

/* This routine initialized the @template record.  It is used to retrieve
 * attributes of records, and to maintain a unique number for the creation
 * of unique record names.  It also generates a dialog window to invoke
 * temp_stamp.
 */
temp_init(){
	char *wid;

	db_store("@template", "$number",
				"# @template record # $attr $db_attr");
	db_store("@template", "N", "# @template record # $db_count");
	db_numstore("@template", "uniq", 0);

	mag_picture("temp.win", "template", "template", WIDTH, HEIGHT, 0);

	mag_append("temp.tab", "temp.sel", 0);
	db_store("temp.sel", "question", "record:");
	mag_append("temp.tab", "temp.vars", 0);
	db_store("temp.vars", "question", "variables:");
	wid = pic_new("template", "table", "temp.tab",
					10, 10, WIDTH - 70, 40, 1, 1);
	tbl_column(wid, "question", 1, 4, "l", "ro");
	tbl_column(wid, "answer", 3, 0, "c", (char *) 0);
	MAG_FREE(wid);

	wid = mag_new("temp.done");
	db_store(wid, "text", "done");
	MAG_FREE(wid);
	wid = pic_new("template", "table", "temp.done",
					WIDTH - 50, 10, 40, 40, 0, 0);
	tbl_column(wid, "text", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	MAG_FREE(pic_new("template", "menu", "temp.sel",
					WIDTH - 50, 10, 40, 40, 1, 1));
	db_numstore("temp.sel", "N", 1);

	mag_append("temp.output", "temp.sel", 0);
	db_store("temp.sel", "error", "fill in record");
	wid = pic_new("template", "table", "temp.output",
					10, 80, WIDTH - 20, 50, 1, 1);
	tbl_column(wid, "error", 1, 0, "c", "ro");
	MAG_FREE(wid);
}

temp_start(){
	mes_subscribe("temp_select", temp_select);
	watch_specify(V_NULL, "temp_select", "temp.sel", "select");
}
