/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This implements sorted list records.  The result of qsort should really
 * be cached, but that hasn't been implemented yet.
 */

#include "magic.h"
#include "value.h"
#include "expr.h"

struct value *x_pop(), *mag_index();

extern struct value **x_sp;

/* The comparison function is evaluated in this context:
 */
struct context sort_ctx;

/* This is the comparison function:
 */
struct value *sort_cmp;

/* Evaluate the comparison routine for these two elements.
 */
sort_docmp(elt1, elt2)
struct value *elt1, *elt2;
{
	double x_dblpop(), val;

	x_bind(&sort_ctx, "1", elt1);
	x_bind(&sort_ctx, "2", elt2);
	x_do(&sort_ctx, sort_cmp);
	val = x_dblpop(&sort_ctx);
	x_cleanup(&sort_ctx);
	return val < 0 ? -1 : (val > 0 ? 1 : 0);
}

/* The comparison routine has to be consistent, in that, if a < b, then
 * b > a, and if a = b, then b = a.  To make sure that this is the case,
 * we call the user defined comparison routine twice, one to compare a
 * with b, and the other time to compare b with a.  If the product is
 * negative, the comparison was consistent.  If the product is positive,
 * the results are inconsistent and we will return 0 to make it consistent.
 * If the product is zero, it may or may not be consistent.  At any rate,
 * returning 0 will be fine as well.
 */
sort_compar(elt1, elt2)
struct value **elt1, **elt2;
{
	int val1, val2;

	val1 = sort_docmp(*elt1, *elt2);
	val2 = sort_docmp(*elt2, *elt1);
	while (x_sp != sort_ctx.c_top)
		val_free(*x_sp++);
	return val1 * val2 >= 0 ? 0 : val1;
}

/* sort_list has two operators:  a list and a comparison function.  Retrieve
 * the list and store it in an array.  Use qsort to sort the list.  The
 * comparison function is evaluated in the context sort_ctx.  The current
 * context is saved in tmp_ctx.  The context and postfix comparison function
 * have to be stored in global variables as qsort does not provide a way of
 * passing these to the C comparison function.
 */
sort_list(c)
struct context *c;
{
	struct value *tmp_cmp, *r, **entry;
	char *rec;
	int i, index, N;
	struct context tmp_ctx;

	tmp_ctx = sort_ctx;
	tmp_cmp = sort_cmp;
	sort_cmp = x_pop(c);
	index = x_numpop(c);
	r = x_pop(c);
	if (sort_cmp == 0 || (rec = val_str(r)) == 0)
		x_null(c);
	else {
		db_numretrieve(rec, "N", &N);
		if ((unsigned) index >= N)
			x_null(c);
		else {
			entry = MAG_ALLOC(N, struct value *);
			for (i = 0; i < N; i++)
				entry[i] = mag_index(rec, i);
			x_copy(c, &sort_ctx);
			qsort((char *) entry, N, sizeof(struct value *),
								sort_compar);
			x_dirpush(entry[index]);
			for (i = 0; i < N; i++)
				if (i != index)
					val_free(entry[i]);
			MAG_FREE(entry);
		}
	}
	val_free(r);
	val_free(sort_cmp);
	sort_cmp = tmp_cmp;
	sort_ctx = tmp_ctx;
}

/* Register the sort function.
 */
sort_start(){
	x_register("$sort", sort_list);
}
