/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This is the quit window.
 */

#include "magic.h"
#include "value.h"

#define WIDTH		300
#define HEIGHT		150

char *mag_new(), *pic_new();

quit_init(){
	char *wid;

	mag_picture("quit.win", "quit", "quit", WIDTH, HEIGHT, 0);
	wid = mag_new("quit.tab");
	db_store(wid, "text", "Do you really want to quit?");
	MAG_FREE(wid);
	wid = pic_new("quit", "table", "quit.tab",
					10, 10, WIDTH - 20, 20, 1, 1);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);

	wid = mag_new("quit.yes");
	db_store(wid, "text", "yes");
	MAG_FREE(wid);
	wid = pic_new("quit", "table", "quit.yes", 10, 45, 40, 20, 0, 1);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
	wid = pic_new("quit", "container", "control", 50, 45, 30, 30, 1, 1);
	db_numstore(wid, "interval", 1);
	db_store(wid, "attr", "status");
	MAG_FREE(wid);

	wid = mag_new("quit.no");
	db_store(wid, "text", "no");
	MAG_FREE(wid);
	wid = pic_new("quit", "table", "quit.no",
					WIDTH - 80, 45, 40, 20, 0, 1);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
	wid = pic_new("quit", "container", "quit",
					WIDTH - 40, 45, 30, 30, 1, 1);
	db_numstore(wid, "interval", 1);
	db_store(wid, "attr", "mapped");
	MAG_FREE(wid);
}
