/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This widget is special, since it consists of an array of other widgets.
 * It doesn't draw anything itself, but calls win_draw for each of the
 * widgets stored in the array.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

#define MAX_LEVEL	16

struct value *mag_index();

char *pic_wid, *pic_mode;
int pic_x, pic_y;

/* Add a new widget of the specified type in name.  Specified are position,
 * size, whether the widget should be framed, and where it should get the
 * values.  Returned is the name of the widget.
 */
char *pic_new(name, type, record, x, y, width, height, frame, select)
char *name, *type, *record;
{
	char *s, *mag_new();

	s = mag_new(name);
	db_store(s, "type", type);
	db_store(s, "record", record);
	db_numstore(s, "x", x);
	db_numstore(s, "y", y);
	db_numstore(s, "width", width);
	db_numstore(s, "height", height);
	db_numstore(s, "frame", frame);
	db_numstore(s, "select", select);
	db_store(s, "$number", "#$record $attr . $concat3");
	return s;
}

/* Get all info of the widget in picture o at index i and return it in obj.
 * Scale the position and size.
 */
pic_getinfo(o, i, obj)
struct object *o, *obj;
{
	if ((obj->o_level = o->o_level + 1) == MAX_LEVEL) {
		printf("recursion level too deep\n");
		return 0;
	}
	if (!win_retrieve(o->o_record, i, obj))
		return 0;
	obj->o_x = o->o_x + obj->o_x * o->o_width / SCALE;
	obj->o_y = o->o_y + obj->o_y * o->o_height / SCALE;
	obj->o_width = obj->o_width * o->o_width / SCALE;
	obj->o_height = obj->o_height * o->o_height / SCALE;
	return 1;
}

/* Test whether x lies between base and length.  Length may be negative.
 */
pic_between(x, base, length){
	if (length > 0)
		return (unsigned) (x - base) < length;
	else
		return (unsigned) (base - x) < -length;
}

/* If there is a widget within o that contains position x, y, which is
 * selectable (i.e., its select attribute is set), return it in ret.
 * This routine is recursive.
 */
pic_find(o, x, y, ret)
struct object *o, *ret;
{
	int i, N, select;
	struct object obj;

	db_numretrieve(o->o_name, "select", &select);
	if (select) {
		if (pic_between(x, o->o_x, o->o_width) &&
		    pic_between(y, o->o_y, o->o_height)) {
			*ret = *o;
			ret->o_valname = val_ref(o->o_valname);
			ret->o_valtype = val_ref(o->o_valtype);
			ret->o_valrecord = val_ref(o->o_valrecord);
			return 1;
		}
		else
			return 0;
	}
	if (!scmp(o->o_type, "picture") || o->o_record == 0)
		return 0;
	db_numretrieve(o->o_record, "N", &N);
	for (i = 0; i < N; i++) {
		if (!pic_getinfo(o, i, &obj))
			continue;
		if (obj.o_width > 0 && obj.o_height > 0 &&
						pic_find(&obj, x, y, ret)) {
			win_free(&obj);
			return 1;
		}
		win_free(&obj);
	}
	return 0;
}

/* Track the mouse.
 */
pic_track(o, x, y)
struct object *o;
{
	int raster, x2, y2;

	if (pic_wid == 0)
		return;
	db_numretrieve("edit.raster", "raster", &raster);
	if (raster) {
		x += 2 - (x + 2) % 5;
		y += 2 - (y + 2) % 5;
	}
	if (scmp(pic_mode, "new") || scmp(pic_mode, "resize")) {
		x2 = x * SCALE / o->o_width - pic_x;
		y2 = y * SCALE / o->o_height - pic_y;
		db_numstore(pic_wid, "width", x2);
		db_numstore(pic_wid, "height", y2);
	}
	else if (scmp(pic_mode, "move")) {
		db_numretrieve(pic_wid, "x", &x2);
		db_numretrieve(pic_wid, "y", &y2);
		x2 += (x - pic_x) * SCALE / o->o_width;
		y2 += (y - pic_y) * SCALE / o->o_height;
		db_numstore(pic_wid, "x", x2);
		db_numstore(pic_wid, "y", y2);
		pic_x = x;
		pic_y = y;
	}
}

/* Apply the selected operator to this object.
 */
pic_op(o, x, y)
struct object *o;
{
	if (scmp(pic_mode, "move")) {
		pic_x = x;
		pic_y = y;
	}
	else if (scmp(pic_mode, "resize")) {
		db_numretrieve(pic_wid, "x", &pic_x);
		db_numretrieve(pic_wid, "y", &pic_y);
		pic_track(o, x, y);
	}
	else if (scmp(pic_mode, "delete"))
		db_store(pic_wid, "type", (char *) 0);
	else if (scmp(pic_mode, "edit")) {
		db_store("edit.buffer", "selection", pic_wid);
		db_numstore("edit.select", "select", 2);
	}
	else
		mag_bleep();
}

/* The mouse has been depressed.
 */
pic_press(o, x, y, count)
struct object *o;
{
	struct value *v_sel;
	char *index, *type, *name, *temp, *vars, *rec;
	int i, N, frame, select, raster;
	struct object obj;

	db_retrieve("edit.mode", "select", &index);
	db_retrieve("edit.mode", index, &pic_mode);
	MAG_FREE(index);
	db_numretrieve("edit.raster", "raster", &raster);
	if (raster) {
		x += 2 - (x + 2) % 5;
		y += 2 - (y + 2) % 5;
	}
	if (scmp(pic_mode, "new")) {
		if (o->o_record == 0) {
			mag_bleep();
			return;
		}
		pic_x = x * SCALE / o->o_width;
		pic_y = y * SCALE / o->o_height;
		db_numretrieve("edit.type", "select", &select);
		v_sel = mag_index("edit.type", select);
		name = val_str(v_sel);
		db_retrieve(name, "type", &type);
		db_numretrieve(name, "select", &select);
		if (scmp(type, "template")) {
			db_retrieve("edit.template", "record", &temp);
			db_retrieve("edit.template", "vars", &vars);
			if (temp == 0 || vars == 0)
				mag_bleep();
			else {
				db_numretrieve("edit.template",
							"frame", &frame);
				temp_stamp(temp, vars);
				db_retrieve(vars, temp, &rec);
				pic_wid = pic_new(o->o_record, "picture", rec,
					pic_x, pic_y, 1, 1, frame, select);
				MAG_FREE(rec);
			}
			MAG_FREE(vars);
			MAG_FREE(temp);
		}
		else {
			db_numretrieve(name, "frame", &frame);
			pic_wid = pic_new(o->o_record, type, "@",
					pic_x, pic_y, 1, 1, frame, select);
		}
		val_free(v_sel);
		MAG_FREE(type);
	}
	else {
		db_numretrieve(o->o_record, "N", &N);
		for (i = 0; i < N; i++) {
			if (!pic_getinfo(o, i, &obj))
				continue;
			if (pic_between(o->o_x + x, obj.o_x, obj.o_width) &&
			    pic_between(o->o_y + y, obj.o_y, obj.o_height)) {
				pic_wid = mag_copy(obj.o_name);
				pic_op(o, x, y);
				win_free(&obj);
				return;
			}
			win_free(&obj);
		}
		mag_bleep();
	}
}

/* The mouse has been released.
 */
pic_release(o, x, y)
struct object *o;
{
	if (pic_wid != 0) {
		pic_track(o, x, y);
		MAG_FREE(pic_wid);
		pic_wid = 0;
	}
	MAG_FREE(pic_mode);
}

/* Draw the picture by drawing all the widgets in it.
 */
pic_draw(w, o)
struct window *w;
struct object *o;
{
	int i, N;
	struct object obj;

	if (o->o_record == 0)
		return;
	db_numretrieve(o->o_record, "N", &N);
	for (i = 0; i < N; i++) {
		if (!pic_getinfo(o, i, &obj))
			continue;
		win_draw(w, &obj);
		win_free(&obj);
	}
}

/* This shows information about picture widgets.
 */
pic_edit(){
	char *wid;

	db_store("edit.buffer", "picture", "edit.buffer.picture");

	mag_append("edit.buffer.pic.n",
			"#edit.buffer selection # record #", 0);
	wid = pic_new("edit.buffer.picture", "table", "edit.buffer.pic.n",
			0, 0, 580, 25, 1, 1);
	tbl_column(wid, "N", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new("edit.buffer.picture", "table",
		"#edit.buffer selection # record #", 12, 30, 568, 400, 1, 1);
	tbl_column(wid, "name", 3, 0, "c", (char *) 0); 
	tbl_column(wid, "record", 3, 0, "c", (char *) 0); 
	tbl_column(wid, "type", 3, 0, "c", (char *) 0); 
	tbl_column(wid, "x", 2, 0, "c", (char *) 0); 
	tbl_column(wid, "y", 2, 0, "c", (char *) 0); 
	tbl_column(wid, "width", 2, 0, "c", (char *) 0); 
	tbl_column(wid, "height", 2, 0, "c", (char *) 0); 
	tbl_column(wid, "frame", 1, 0, "c", (char *) 0); 
	tbl_column(wid, "select", 1, 0, "c", (char *) 0); 
	db_numstore(wid, "number", 20);
	MAG_FREE(pic_new("edit.buffer.picture", "scroll", wid,
						0, 30, 12, 400, 1, 1));
	MAG_FREE(wid);
}
