/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This file contains the main loop for the UNIX/BSD operating system
 * and the ISIS and META systems.  In a main loop it calls select on the
 * X11 and ISIS file descriptors.  Appropriate routines are invoked to
 * handle input on these file descriptors.  In any case it calls the X11
 * input routine since X11 may enqueue things internally.
 */

#include "magic.h"
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>
#include <X11/Xlib.h>
#include "isis.h"

#define NFD	32		/* # file descriptors */

extern Display *x_dpy;
extern mag_done;

fd_set fd_read;			/* fd bit mask (see select(2)) */
int (*fd_func[NFD])();		/* functions to invoke */

/* When something happens on fd, invoke func.
 */
sel_open(fd, func)
int (*func)();
{
	FD_SET(fd, &fd_read);
	fd_func[fd] = func;
}

/* This function is invoked when something happens on the X11 fd.  In an
 * infinite loop it flushes the X11 output queue and sees if there are
 * more events to process.
 */
MAG_input(){
	win_sync();
}

/* When input is available for isis, this routine is invoked.
 */
ISIS_input(){
	isis_accept_events(0);
}

/* This is the main loop.
 */
sel_loop(){
	fd_set set;
	int fd;

	for (;;) {
		MAG_input();
		if (mag_done)
			return;
		set = fd_read;
		select(NFD, &set, (fd_set *) 0, (fd_set *) 0,
						(struct timeval *) 0);
		for (fd = 0; fd < NFD; fd++)
			if (fd_func[fd] != 0 && FD_ISSET(fd, &set))
				(*fd_func[fd])();
	}
}

/* ISIS overflow signals are ignored.
 */
sel_overflow(){
	printf("*** caught (and ignored) overflow signal ***\n");
}

/* ISIS has two file descriptors:  one to talk to the protos process, and
 * the other for direct interclient communication.  In both cases invoke
 * isis_accept_events() through ISIS_input().
 */
sel_init(){
	signal(SIGUSR1, sel_overflow);
	sel_open(x_dpy->fd, (int (*)()) 0);
	sel_open(isis_socket, ISIS_input);
	sel_open(intercl_socket, ISIS_input);
}
