/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This builds an editor window.  I'm about to change this code so I can
 * stamp out editors, so I won't put more comments in currently.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

extern char *mag_me;

char *pic_new(), *mag_new();

/* Like tbl_column, but creates a data base schema at the same time.
 */
edit_column(wid, attr, descr, width)
char *wid, *attr, *descr;
{
	db_store("edit.schema", attr, descr);
	tbl_column(wid, attr, width, 0, "c", (char *) 0);
}

edit_record(){
	char *pic, *wid, *tbl, buf[256];

	pic = mag_new("edit.buffer");

	/* Make tables to edit attributes.
	 */
	mag_append("edit.attr", "edit.buffer", 0);
	wid = pic_new(pic, "table", "edit.attr", 12, 0, 140, 20, 1, 1);
	tbl_column(wid, "attr", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	mag_append("edit.attr2", "#edit.buffer selection #", 0);
	wid = pic_new(pic, "table", "edit.attr2", 152, 0, 428, 20, 1, 1);
	tbl_column(wid, "#edit.buffer attr #", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	/* Make tables that display the record.
	 */
	db_store("edit.record", "$number",
		"#edit.buffer selection # $attr $db_attr");
	db_store("edit.record", "N", "#edit.buffer selection # $db_count");
	tbl = pic_new(pic, "table", "edit.record", 12, 30, 140, 400, 1, 1);
	db_numstore(tbl, "number", 20);
	tbl_column(tbl, "name", 1, 0, "c", "ro");

	wid = pic_new(pic, "table", "edit.record", 152, 30, 428, 400, 1, 1);
	db_numstore(wid, "transpose", 1);
	sprintf(buf, "#%s number #", tbl);
	db_store(wid, "number", buf);
	sprintf(buf, "#%s start #", tbl);
	db_store(wid, "start", buf);
	tbl_column(wid, "#edit.buffer selection #", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	MAG_FREE(pic_new(pic, "scroll", tbl, 0, 30, 12, 400, 1, 1));
	MAG_FREE(tbl);
	MAG_FREE(pic);
}

/* This picture shows tables.
 */
edit_table(){
	char *pic, *wid;

	pic = mag_new("edit.buffer");

	mag_append("edit.nrow", "#edit.buffer selection #", 0);
	wid = pic_new(pic, "table", "edit.nrow", 0, 0, 580, 25, 1, 1);
	tbl_column(wid, "N", 8, 0, "c", (char *) 0);
	MAG_FREE(wid);

	wid = pic_new(pic, "table", "#edit.buffer selection #",
						12, 30, 568, 400, 1, 1);
	tbl_column(wid, "name", 1, 0, "c", (char *) 0);
	db_numstore(wid, "number", 20);
	MAG_FREE(pic_new(pic, "scroll", wid, 0, 30, 12, 400, 1, 1));
	MAG_FREE(wid);

	MAG_FREE(pic);
}

edit_widget(){
	char *pic, *wid;

	/* This table shows the parameters of the configuration and
	 * actual widget displays.
	 */
	mag_append("edit.conftab", "edit.schema", 0);
	mag_append("edit.conftab", "#edit.buffer selection #", 0);
	wid = pic_new("edit.conf", "table", "edit.conftab",
						0, 0, 580, 50, 1, 1);
	edit_column(wid, "record",  "record",	3);
	edit_column(wid, "type",    "type",	3);
	edit_column(wid, "x",	    "x",	2);
	edit_column(wid, "y",	    "y",	2);
	edit_column(wid, "width",   "width",	2);
	edit_column(wid, "height",  "height",	2);
	edit_column(wid, "frame",   "fr",	1);
	edit_column(wid, "select",  "sel",	1);
	MAG_FREE(wid);

	/* This picture shows the configuration of the widget.
	 */
	pic = mag_new("edit.buffer");
	MAG_FREE(pic_new(pic, "picture", "edit.conf",
			0, 0, SCALE, SCALE, 0, 0));
	MAG_FREE(pic_new(pic, "picture",
			"#edit.buffer edit.buffer selection # type # #",
			0, 70, SCALE, SCALE, 0, 0));
	MAG_FREE(pic);
}

edit_type(type, frame, select)
char *type;
{
	char *wid = mag_new("edit.type");

	db_store(wid, "type", type);
	db_numstore(wid, "frame", frame);
	db_numstore(wid, "select", select);
	MAG_FREE(wid);
}

/* This picture shows a picture.
 */
edit_pic(){
	char *wid, *pic;

	pic = mag_new("edit.buffer");

	mag_append("edit.scale", "scale", 0);
	wid = pic_new(pic, "table", "edit.scale", 0, 0, 90, 20, 0, 0);
	tbl_column(wid, "name", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new(pic, "container", "edit.scale", 0, 0, 90, 20, 1, 1);
	db_store(wid, "attr", "scale");
	db_numstore(wid, "interval", 1);
	MAG_FREE(wid);

	mag_append("edit.raster", "raster", 0);
	wid = pic_new(pic, "table", "edit.raster", 0, 30, 90, 20, 0, 0);
	tbl_column(wid, "name", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new(pic, "container", "edit.raster", 0, 30, 90, 20, 1, 1);
	db_store(wid, "attr", "raster");
	db_numstore(wid, "interval", 1);
	MAG_FREE(wid);
	db_numstore("edit.raster", "raster", 1);

	db_numstore("edit.mode", "select", 0);
	mag_append("edit.mode", "new", 0);
	mag_append("edit.mode", "move", 0);
	mag_append("edit.mode", "resize", 0);
	mag_append("edit.mode", "edit", 0);
	mag_append("edit.mode", "delete", 0);
	wid = pic_new(pic, "table", "edit.mode", 0, 80, 90, 20, 0, 0);
	db_store(wid, "height", "# $record record # N # 20 *");
	tbl_column(wid, "name", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new(pic, "menu", "edit.mode", 0, 80, 90, 20, 1, 1);
	db_store(wid, "height", "# $record record # N # 20 *");
	MAG_FREE(wid);

	db_numstore("edit.type", "select", 0);
	edit_type("graph", 1, 0);
	edit_type("container", 1, 1);
	edit_type("table", 1, 1);
	edit_type("menu", 1, 1);
	edit_type("scroll", 1, 1);
	edit_type("picture", 1, 0);
	edit_type("line", 0, 0);
	edit_type("arrow", 0, 0);
	edit_type("box", 1, 0);
	edit_type("circle", 0, 0);
	edit_type("template", 0, 0);
	wid = pic_new(pic, "table", "edit.type", 0, 225, 90, 20, 0, 0);
	db_store(wid, "height", "# $record record # N # 20 *");
	tbl_column(wid, "type", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new(pic, "menu", "edit.type", 0, 225, 90, 20, 1, 1);
	db_store(wid, "height", "# $record record # N # 20 *");
	MAG_FREE(wid);

	mag_append("edit.temptab", "edit.template", 0);
	wid = pic_new(pic, "table", "edit.temptab", 100, 0, 450, 25, 1, 1);
	tbl_column(wid, "record", 3, 0, "c", (char *) 0);
	tbl_column(wid, "vars", 3, 0, "c", (char *) 0);
	tbl_column(wid, "frame", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	wid = pic_new(pic, "picture", "#edit.buffer selection #",
						100, 60, 0, 0, 1, 1);
	db_store(wid, "width", "#edit.scale scale # 450 8192 ?");
	db_store(wid, "height", "#$record width #");
	db_store(wid, "frame", "#edit.scale scale #");
	MAG_FREE(wid);

	MAG_FREE(pic);
}

edit_init(){
	char *wid;

	mag_picture("edit.win", "edit", "edit", 600, 600, 0);

	/* Initialize all the stuff for the different widget types
	 */
	pic_edit();
	tbl_edit();
	cont_edit();
	graph_edit();

	wid = pic_new("edit", "container", "edit", 10, 10, 30, 30, 1, 1);
	db_store(wid, "attr", "mapped");
	db_numstore(wid, "interval", 1);
	MAG_FREE(wid);

	/* This table holds the name of the record/widget to be edited.
	 * The name is stored in edit.buffer#selection.
	 */
	mag_append("edit.tab", "edit.buffer", 0);
	wid = pic_new("edit", "table", "edit.tab", 50, 10, 330, 30, 1, 1);
	tbl_column(wid, "selection", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	db_numstore("edit.select", "select", 0);
	mag_append("edit.select", "rec", 0);
	mag_append("edit.select", "tbl", 0);
	mag_append("edit.select", "wid", 0);
	mag_append("edit.select", "pic", 0);
	mag_append("edit.sel.text", "edit.select", 0);
	wid = pic_new("edit", "table", "edit.sel.text",
						390, 10, 200, 30, 0, 0);
	tbl_column(wid, "0", 1, 0, "c", (char *) 0);
	tbl_column(wid, "1", 1, 0, "c", (char *) 0);
	tbl_column(wid, "2", 1, 0, "c", (char *) 0);
	tbl_column(wid, "3", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new("edit", "menu", "edit.select", 390, 10, 200, 30, 1, 1);
	db_numstore(wid, "horiz", 1);
	MAG_FREE(wid);

	/* Make the picture.
	 */
	MAG_FREE(pic_new("edit", "picture",
				"#edit.buffer edit.select select # #",
						10, 50, SCALE, SCALE, 0, 0));

	edit_record();
	edit_table();
	edit_widget();
	edit_pic();
}
