/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 *
 * This simulates some machine.  The machine has a number of input containers
 * from which it will try to take the necessary proportions to produce a
 * certain output product.  If there's not enough input in the input
 * containers, it will stop.  It takes time to produce the output product.
 */

#include "value.h"

struct value **mes_alloc(), **mes_ok(), **mes_error();
struct value *db_get(), *mag_index();

char *mach_name;

struct value **mach_put(req)
struct value **req;
{
	int value, chunk, interval;
	char *cont;

	chunk = 100;	/* HACK */
	if (!db_numretrieve(val_str(req[2]), "interval", &interval))
		return mes_error("no such container");
	db_numretrieve(val_str(req[2]), "value", &value);
	if ((value += chunk) < 0)
		value = 0;
	else if (value > interval) {
		value = interval;
		printf("will somebody please clean up the mess\n");
	}
	db_numstore(val_str(req[2]), "value", value);
	return mes_ok();
}

/* The following routine should be subdivided into several different ones
 * for several different events.
 */
struct value **mach_update(req)
struct value **req;
{
	extern db_seq, mag_reply();
	int t, time, timer, value, chunk, i, N;
	struct value **mes, *cont;

	db_put("clock", "value", req[4]);
	t = val_int(req[4]);
	if (db_numretrieve("machine", "timer", &timer)) {
		/* In the process of producing an output product.
		 */
		if (t < timer)
			return mes_ok();
		mes = mes_alloc(3);
		mes[1] = val_sstr("iput", 0);
		mes[2] = db_get("machine", "product", db_seq);
		mes_send_request(db_get("machine", "dest", db_seq),
							mes, mag_reply);
		db_store("machine", "timer", (char *) 0);
	}
	db_numretrieve("onoff", "value", &value);
	if (value == 0)
		return mes_ok();
	db_numretrieve("machine", "N", &N);
	for (i = 0; i < N; i++) {
		cont = mag_index("machine", i);
		db_numretrieve(val_str(cont), "value", &value);
		db_numretrieve(val_str(cont), "chunk", &chunk);
		if (value < chunk) {
			printf("underflow\n");
			value = 0;
		}
		else
			value -= chunk;
		db_numstore(val_str(cont), "value", value);
		val_free(cont);
	}
	db_numretrieve("machine", "time", &time);
	db_numstore("machine", "timer", t + time);
	return mes_ok();
}

mach_init(name)
char *name;
{
	char *cont;

	mach_name = name;
	mag_init(name);
	fac_register();
	mes_subscribe("iput", mach_put);
	mes_subscribe("update", mach_update);
}

main(argc, argv)
char *argv[];
{
	mach_init(argv[1]);
	win_main_loop();
	mag_exit(0);
}
