/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <strings.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_client.h"
#include "tutil.h"

char *usage = "usage: tutil <command>|help <args>";

char *cmds[] = {

	/* table interface library */
 	/* use TMSG numbering */
		"create",
		"destroy",
		"info",
		"rename_rel",
		"rename_col",
		"remove_dups",
		"insert",
		"delete",
		"enumerate",
		"endenum",

	/* utilities library */
#define CMD_LOAD_ATTR	11
		"load_attr",
#define CMD_LOAD_TUPLES	12
		"load_tuples",
#define CMD_DUMP_ATTR	13
		"dump_attr",
#define CMD_DUMP_TUPLES	14
		"dump_tuples",
#define CMD_LIST_TABLES	15 /* defined in this tool */
        "list_tables",
#define CMD_LOAD_TABLES	16
        "load_tables",
#define CMD_RESET 17
	"reset",
#define CMD_INFO_TABLES	18 /* defined in this tool */
        "info_tables",
#define CMD_FILTER_TUPLES 19 /* defined in this tool */
	"filter",

		""
};

char *res[] = {
	"bad file format",
	"bad open",
	"tutil must be broken - this cannot happen",
	"tutil must be broken - this cannot happen",
	"tutil must be broken - this cannot happen",
	"bad column number",
	"tuple not found",
	"duplicate tuple",
	"table exists",
	"table does not exist",
	"failure",
	"tutil must be broken - this cannot happen",
	"Success"
};

main(argc, argv)
int argc;
char **argv;
{
  AttDes *attributes;
  TableInfo info;
  int i, n, v, type, column_num, nrel;
  PTR val;
  char *cp, *getenv(), *expr, rel[11], s[11];
  long isisport = 0;
  long state;
  message *tuple, *filter, *cond;

  if (argc < 2) error(usage);
  for (cp = argv[1]; *cp; cp++)
    if (*cp == '-') *cp = '_';
  for (i=0; *cmds[i] && strcmp(argv[1], cmds[i]); i++);
  if (!*cmds[i]) help();
  
  cp = getenv("ISISPORT");
  if (cp) isisport = atoi(cp);
  v = t_tableinit(isisport);
  if (v != TBL_SUCCESS) result(v);

  switch(i+1)
  {
  case TMSG_CREATE:
	fprintf(stderr, "tutil: create not implemented - use attr_load\n");
	exit(1);

  case TMSG_DESTROY:
	if (argc < 3) help();
  	v = t_destroy(argv[2]);
  	result(v);
	break;

  case TMSG_INFO:
	if (argc < 3) help();
	v = t_info(argv[2], &info, &attributes);
	if (v != TBL_SUCCESS) result(v);

	printf("relation \"%s\": ", argv[2]);
	if (info.stable) printf("stable, ");
	printf("%d replicas, %d attributes, %d tuples, version #%d\n",
		info.repl_factor, info.num_attr,
	       	info.num_tuples, info.version);

	for (i = 0; i < info.num_attr; i++)
		printf("\tattribute \"%s\": type %s, user info %d\n",
		       attributes[i].AttName,
		       type_to_name(attributes[i].type),
		       attributes[i].clientData);

	result(v);
	break;

  case TMSG_RENAME_REL:
	if (argc < 4) help();
	if (v != TBL_SUCCESS) result(v);
  	v = t_rename_rel(argv[2], argv[3]);
  	result(v);
	break;

  case TMSG_RENAME_ATTR:
	if (argc < 5) help();
  	result(t_rename_attr(argv[2], atoi(argv[3]), argv[4]));
	break;

  case TMSG_REMOVE_DUPS:
	if (argc < 3) help();
  	result(t_remove_dups(argv[2]));
	break;

  case TMSG_INSERT:
	fprintf(stderr, "tutil: insert not implemented - use load_tuples\n");

  case TMSG_REMOVE:
	result(enumerate(argv[2], NULL, TRUE, TBL_SORTALL));
	break;

  case TMSG_LIST:
	if (argc < 3) help();
	result(enumerate(argv[2], FALSE, NULL,
			(argc == 4) ? atoi(argv[3]) : TBL_SORTALL));
	break;

  case CMD_LOAD_ATTR:
	if (argc < 4) help();
	if (v != TBL_SUCCESS) result(v);
	result(tut_load_attr(argv[2], argc > 4, 1, FALSE, argv[3]));
	break;

  case CMD_LOAD_TUPLES:
	if (argc < 4) help();
  	result(tut_load_tuples(argv[2], &n, argv[3], FALSE));
	break;

  case CMD_DUMP_ATTR:
	if (argc < 4) help();
	result(tut_dump_attr(argv[2], argv[3], "w"));
	break;

  case CMD_DUMP_TUPLES:
	if (argc < 4) help();
	result(tut_dump_tuples(argv[2], TBL_SORTALL, argv[3], "w"));
	break;

  case CMD_LIST_TABLES:
	result(enumerate(TBL_SYSREL, NULL, FALSE, TBL_SORTALL));
	break;

  case CMD_INFO_TABLES:
	result(info_tables());
	break;

  case CMD_LOAD_TABLES:
  	if (argc < 3) help();
	result(tut_load_tables(argv[2]));
	break;

  case CMD_RESET:
	result(t_reset(argc > 2));
	break;

  case CMD_FILTER_TUPLES:
	if (argc < 3) help();
	v = t_info(argv[2], &info, &attributes);
	if (v != TBL_SUCCESS) result(v);

	filter = msg_newmsg();
	if (argc > 3)
	{
	    expr = argv[3];	  
	    n = sscanf(expr, "%d %10s %10s", &column_num, rel, s);
	    while (n == 3)
	    {
		cond = msg_newmsg();
		type_pack(TYPE_INT, cond, 0, &column_num);

		type = attributes[column_num].type;
		ascii_to_type(type, s, NULL, &val);
		type_pack(type, cond, 1, val);

		nrel = type_relop(rel);
		type_pack(TYPE_INT, cond, 2, &nrel); 

		msg_put(filter, "%m", cond);

		expr = index(expr, '&');
		if (expr) 
		{
			expr += 1;
			n = sscanf(expr, "%d %10s %10s", &column_num, rel, s);
		}
		else 
			n = 0;
	    }
	}
	result(enumerate(argv[2], filter, FALSE, TBL_SORTALL));
	msg_delete(filter);
	break;
  }
  
  exit(0);
}

int enumerate(relation, filter, delete, column)
char *relation;
message *filter;
int delete, column;
{
  int v, i, n, *p, type, c;
  char answer[100];
  long state;
  AttDes *attrs;
  TableInfo info;
  message *tuple;

  
  v = t_startenum(relation, column, filter, &info, &attrs, &state);
  if (v != TBL_SUCCESS) result(v);

  v = t_enumerate(state, &tuple);
  if (v != TBL_SUCCESS) result(v);

  while(tuple)
  {
    	tut_write_tuple(stdout, info.num_attr, attrs, tuple);
	msg_delete(tuple); /* add this line */

	if (delete)
	{
		printf("delete [nyq]? ");
		c = scanf("%s", answer);
		if (c != 1) return t_endenum(state);

		if (answer[0] == 'q')
		  	return t_endenum(state);
		if (answer[0] == 'y')
		{	
		  	v = t_delete(state);
			if (v != TBL_SUCCESS) {
			    t_endenum(state);
			    return(v);
			}
		}
	}

	v = t_enumerate(state, &tuple);
	if (v != TBL_SUCCESS) {
	    t_endenum(state);
	    return(v);
	}
  }
  t_endenum(state);
  return TBL_SUCCESS;
}


error(str)
char *str;
{
	fprintf(stderr, "%s\n", str);
	exit(1);
}

result(val)
int val;
{
	if (val < 0) fprintf(stderr, "Error: ");
	fprintf(stderr, "%s\n", res[val-TUT_MIN_CODE]);
	if (val < 0) exit(1);
}

help()
{
  fprintf(stderr, "%s\nCommands are:\n", usage);
/*fprintf(stderr, "  create \trelation\n"); */
  fprintf(stderr, "  destroy \trelation\n");
  fprintf(stderr, "  info \t\trelation\n");
  fprintf(stderr, "  rename_rel \trelation  new_relation\n");
  fprintf(stderr, "  rename_col \trelation  column_num  attr_name\n");
  fprintf(stderr, "  remove_dups \trelation\n");
/*fprintf(stderr, "  insert \t\trelation  file\n"); */
  fprintf(stderr, "  delete \trelation\n");
  fprintf(stderr, "  enumerate \trelation  [column_num]\n");
  fprintf(stderr, "  filter \trelation col.rel.val ...\n");
  fprintf(stderr, "  load_attr \trelation  file\n");
  fprintf(stderr, "  load_attr \trelation  file [stable]\n");
  fprintf(stderr, "  load_tuples \trelation  file\n");
  fprintf(stderr, "  dump_attr \trelation  file\n");
  fprintf(stderr, "  dump_tuples \trelation  file\n");
  fprintf(stderr, "  list_tables\n");
  fprintf(stderr, "  info_tables\n");
  fprintf(stderr, "  load_tables \tfile\n");
  fprintf(stderr, "  reset [all]\n");

  exit(1);
}


  
info_tables()

{
    TableInfo info,sysinfo;
    int i;
    PTR state,p;
    int v;
    message * tuple;
    char * name;


    v = t_startenum(TBL_SYSREL, TBL_SORTALL, NULL, &sysinfo, NULL, &state);
    if (v != TBL_SUCCESS) result(v);

    if (i) {
	printf("%-*sStable  Repl  Cols  Tuples    Version\n",
	       TBL_MAXNAME,"Name");

	for (i = 0; i < sysinfo.num_tuples; i++) {
	    v = t_enumerate(state, &tuple);
	    if (v != TBL_SUCCESS) result(v);
	    name = NULL;
	    type_unpack(TYPE_STRING,tuple,0,&name);
	    v = t_info(name,&info,NULL);
	    printf("%-*s%6c  %4d  %4d  %6d  %9d\n",
		   TBL_MAXNAME,name,
		   info.stable ? 'Y' : 'N',
		   info.repl_factor,
		   info.num_attr,
		   info.num_tuples,
		   info.version);
	}
    }
    t_endenum(state);
    return TBL_SUCCESS;
}

    
