/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <search.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_mgr.h" 

RelDes *root_rel = NULL;

RelDes *rel_lookup(name, create)
RELNAME	*name;
int	create;
{
  RelDes *rel_des, **p;

  rel_des = (RelDes *)malloc(sizeof(RelDes));
  strncpy(rel_des->name, name, sizeof(RELNAME));
  rel_des->exist = 0;

  if (create)
  {
 	p = (RelDes **)tsearch(rel_des, &root_rel, rel_cmp);
  	if (*p != rel_des) free(rel_des);
  } else
  {	
	p = (RelDes **)tfind(rel_des, &root_rel, rel_cmp);
	if (!p)
	{
		free(rel_des);
		return NULL;
	}
  }

  return *p;
}

rel_cmp(r1, r2)
RelDes *r1, *r2;
{
  return strncmp(r1->name, r2->name, sizeof(RELNAME));
}

static RelDes *T_cmp_rel;
static int T_cmp_col;

T_cmp_init(rel, col)
RelDes *rel;
int col;
{
 	T_cmp_rel = rel;
	T_cmp_col = col;
}

T_cmp(t1, t2)
message *t1, *t2;
{
  return tuple_cmp(T_cmp_rel, t1, t2, T_cmp_col);
}

T_dcmp(t1, t2)
message *t1, *t2;
{
  int c;

  c = tuple_cmp(T_cmp_rel, t1, t2, T_cmp_col);
  return c ? c : (t1 - t2);
}

tuple_cmp(rel_des, t1, t2, cmp_column_num)
RelDes *rel_des;
message *t1, *t2;
int cmp_column_num;
{
  int	column_num, b, type;

  if (cmp_column_num == TBL_SORTALL) {

	for (column_num = 0;
		column_num < rel_des->num_attributes;
		column_num++)
	{ 
		b = tuple_cmp(rel_des, t1, t2, column_num);
		if (b) return b;
	}
	return 0;
  }

  type = rel_des->attributes[cmp_column_num].type;
  return packcmp(type, t1, cmp_column_num, t2, cmp_column_num);
}

int tuple_test(rel_des, filter, tuple)
RelDes *rel_des;
message *filter, *tuple;
{
  int n, type;
  int *column_num, *sense;
  message *cond;

  msg_rewind(filter);
  n = msg_get(filter, "%-m", &cond);
  while (n)
  {
    	column_num = sense = NULL;
	type_unpack(TYPE_INT,cond, 0, &column_num);
	type_unpack(TYPE_INT,cond, 2, &sense);
	if (*column_num >= 0 && *column_num < rel_des->num_attributes)
	{
	  	type = rel_des->attributes[*column_num].type;
		if (!packrel(type, *sense, tuple, *column_num, cond, 1))
			return 0;
	}
	n = msg_get(filter, "%-m", &cond);
  }
  return 1;
}

int sys_insert(name)
RELNAME name;
{
  message *mp;
  mp = msg_newmsg();
  type_pack(TYPE_STRING,mp, 0, name);
  return T_insert(sys_rel, mp, TRUE);
}

int sys_remove(name)
RELNAME name;
{
  message *mp;
  mp = msg_newmsg();
  type_pack(TYPE_STRING,mp, 0, name);
  return T_remove(sys_rel, mp);
}
