/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_mgr.h"
#include "table_client.h"

void table_process(mp)
message *mp;
{
  int replier, op, i, v;
  RELNAME relation;
  RelDes *rel_des;
  int log;

  log = TRUE; /* place-holder */
  replier = elected || (my_address.addr_site ==
			msg_getsender(mp)->addr_site);

  msg_get(mp, "%d", &op);

  if (op != TMSG_RESET) 
  {
	msg_get(mp, "%s", relation);
  	if (op == TMSG_CREATE || op == TMSG_DESTROY)
	{
		rel_des  = rel_lookup(relation, op == TMSG_CREATE);
	  	if (log) log_write(gaddr_p, mp);
	} else
	{
		rel_des  = rel_lookup(relation, FALSE);
	  	if (rel_des && rel_des->stable && log) log_write(gaddr_p, mp);
	}	
	if (!rel_des) v = TBL_TABLE_NOEXIST;
  }

  switch (op) {

  case TMSG_CREATE:
  {
	message *mp1;
	int stable, repl_factor, num_attributes, delete, randomize;
	AttDes *attributes, *a;

	msg_get(mp, "%d %d %d %-m %d %d",
		&stable, &repl_factor, &num_attributes,
		&mp1, &delete, &randomize);

	attributes = (AttDes *)malloc(sizeof(AttDes)*num_attributes);
	for (i = 0; i < num_attributes; i++) {
		a = &attributes[i];
		msg_get(mp1, "%s %d %d %d",
			a->AttName, &a->type, &a->clientData);
	}

	if (rel_des)
	  	v = T_create(rel_des, stable, repl_factor, num_attributes,
			attributes, delete, randomize);
	if (replier){
		log_flush(gaddr_p);
		reply(mp, "%d %d", rel_des->version, v);
	}
  }
  break;

  case TMSG_DESTROY:
  {
	if (rel_des) v = T_destroy(rel_des);
	if (replier)
	{
		log_flush(gaddr_p);
		reply(mp, "%d", v);
	}
  }
  break;

  case TMSG_INFO:
  {
	AttDes *attributes;
	TableInfo info;
	message *mp1, *mp2;

	if (rel_des) v = T_info(rel_des, &info, &attributes);

	if (v == TBL_SUCCESS)
	  	mp1 = attrs_to_mp(attributes, info.num_attr);
	else
	  	mp1 = msg_newmsg();

	mp2 = msg_gen("%d %d %d %d %d",
		info.stable, info.repl_factor, info.num_attr,
		info.num_tuples, info.version);

	if (replier) reply(mp, "%m %m %d", mp2, mp1, v);
	msg_delete(mp1);
	msg_delete(mp2);
  }
  break;

  case TMSG_RENAME_REL:
  {
	RELNAME new_relname;

	msg_get(mp, "%s", new_relname);
	if (rel_des) v = T_rename_rel(rel_des, new_relname);
	if (replier)
	{
		log_flush(gaddr_p);
		reply(mp, "%d", v);
	}
  }
  break;

  case TMSG_RENAME_ATTR:
  {
	RELNAME new_attr;
	int attr_col;

	msg_get(mp, "%d %s", &attr_col, new_attr);
	if (rel_des) v = T_rename_attr(rel_des, attr_col, new_attr);
	if (replier)
	{
		log_flush(gaddr_p);
		reply(mp, "%d", v);
	}
  }
  break;

  case TMSG_REMOVE_DUPS:
  {
	if (rel_des) v = T_remove_dups(rel_des);
	if (replier)
	{
		log_flush(gaddr_p);
		reply(mp, "%d", v);
	}
  }
  break;

  case TMSG_INSERT:
  {
	message *tuple;
	int suppress_dups;

	msg_get(mp, "%m %d", &tuple, &suppress_dups);
	if (rel_des) v = T_insert(rel_des, tuple, suppress_dups);
	if (replier)
	{
		log_flush(gaddr_p);
		reply(mp, "%d", v);
	}
  }
  break;

  case TMSG_REMOVE:
  {
	message *tuple;

	msg_get(mp, "%-m", &tuple);

	if (rel_des) v = T_remove(rel_des, tuple);
	msg_delete(tuple);
	if (replier)
	{
		log_flush(gaddr_p);
		reply(mp, "%d", v);
	}
  }
  break;

  case TMSG_LIST:
  {
	message *filter, **arr, *mp1, *mp2, *mp3;
	int column_num;
	TableInfo info;
	AttDes *attrs;

	msg_get(mp, "%d %-m", &column_num, &filter);

	if (rel_des)
		v = T_list(rel_des, column_num, filter, &info, &attrs, &arr);

	if (!rel_des || v != TBL_SUCCESS)
	  	info.num_tuples = info.num_attr = 0;

	msg_delete(filter);

	mp1 = msg_newmsg();
	for (i = 0; i < info.num_tuples; i++)
		msg_put(mp1, "%m", arr[i]);
  	free(arr);

	mp2 = msg_newmsg();
	msg_put(mp2, "%d %d %d %d %d",
		info.stable, info.repl_factor, info.num_attr,
		info.num_tuples, info.version);

	mp3 = attrs_to_mp(attrs, info.num_attr);

	if (replier) reply(mp, "%m %m %m %d", mp2, mp3, mp1, v);
	msg_delete(mp1);
	msg_delete(mp2);
	msg_delete(mp3);
  }
  break;

  case TMSG_RESET:
  {
	int hard;

    	msg_get(mp, "%d", &hard);
	v = T_reset(hard);
	if (replier){
	  	log_flush(gaddr_p);
		reply(mp, "%d", v);
	}
  }
  break;

  default:
  	if (replier) reply(mp, "%d", TBL_FAILURE);
  break;

  }
}

message *attrs_to_mp(attrs, num_attr)
AttDes *attrs;
{
  message *mp;
  int i;

  mp = msg_newmsg();
  for (i = 0; i < num_attr; i++) {
  	msg_put(mp, "%s %d %d",
		attrs[i].AttName, attrs[i].type, attrs[i].clientData);
  }
  return mp;
}
