/*

Copyright 1990 by K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "table.h"
#include "tutil.h"
#include "types.h"

tut_load_tuples(relation, num_tuples, filename, suppress_dups)
RELNAME relation;
int *num_tuples;
char *filename;
int suppress_dups;
{
  FILE *in;
  AttDes *attributes;
  TableInfo info;
  message *tuple, *msg_newmsg();
  int n, count, column_num, type, val, i;
  char s[TUT_MAXSTRING];

  val = t_info(relation, &info, &attributes);
  if (val != TBL_SUCCESS) return val;
  
  in = fopen(filename, "r");
  if (!in) return TUT_OPEN_FAILED;

  for(*num_tuples = 0;
      tut_read_tuple(in, info.num_attr, attributes, &tuple);
      *num_tuples += 1)
  {
	val = t_insert(relation, tuple, suppress_dups);
	if (val != TBL_SUCCESS) return val;
  }
  fclose(in);
  return TBL_SUCCESS;
}

