/*

Copyright 1990 by K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <ctype.h>
#include "isis.h"
#include "table.h"
#include "tutil.h"
#include "types.h"

int tut_load_attr(relation, stable, repl_factor, delete, filename)
RELNAME	relation;		/* Relation name */
int	stable;			/* type of relation: TRUE  if stable	*/
				/*		     FALSE if not	*/
int	repl_factor;		/* replication factor 			*/
int	delete;			/* delete attribute if it already exists */
char	*filename;		/* name of file */
{
  FILE	*in;
  AttDes *attributes, *a;
  TableInfo info;
  int	count, i, val,j;
  char type[32];

  in = fopen(filename, "r");
  if (!in) return TUT_OPEN_FAILED;

  attributes = (AttDes *) malloc(sizeof(AttDes) * TBL_MAXATTRS);

  for(i = 0; count != EOF; i++)
  {
	a = &attributes[i];
	count = fscanf(in, "%s %s %d",
		       a->AttName, type, &a->clientData);
	if (count != EOF) {
	    if (count != 3) return TUT_BAD_FORMAT;
	    if (isdigit(type[0]))
	      a->type = atoi(type);
	    else {
		for (j=0;j<NUM_TYPES;j++) {
		    if (!strcmp(type,type_to_name(j))) {
			a->type = j;
			break;
		    }
		}
		if (j == NUM_TYPES) return TUT_BAD_FORMAT;
	    }
	}
  }
  fclose(in);

  info.stable = stable;
  info.repl_factor = repl_factor;
  info.num_attr = i-1; 
  val = t_create(relation, &info, attributes, delete);
  free(attributes);
  return val;
}
