/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_client.h"
#include "table_lib.h"

int t_list(relation, column_num, filter, info, attr, arr)
RELNAME relation;		/* name of relation */
int column_num;			/* column (attribute) number to sort by	  */
				/* TBL_NOSORT means order is unimportant  */
				/* TBL_SORTALL means sort lexigraphically */
				/* on all columns			  */

message *filter;		/* filter on tuples returned		  */
				/* list of triples (conjunction):	  */
				/*	column number to compare,	  */
				/*	value to compare,		  */
				/*	sense of comparison		  */

TableInfo *info;		/* output: current table info		  */
AttDes **attr;			/* output: current table schema		  */

message ***arr;			/* output: array of tuples		  */
				/*	   memory for tuple is allocated  */
				/* 	   NULL if no tuple returned	  */
{
  message *mp_info, *mp_attr, *mp_list;
  int i, n, v;
  message *f;

  /* create null message if NULL is passed in */
  f = filter ? filter : msg_newmsg();

  n = abcast(t_addrp, WORK_ENTRY,
	       "%d %s %d %m",
	       TMSG_LIST, relation, column_num, f,
	       1, "%-m %-m %-m %d", &mp_info, &mp_attr, &mp_list, &v);
  if (n != 1) return TBL_FAILURE;
  if (v != TBL_SUCCESS) return v;

  mp_to_info(mp_info, info);
  if (attr) mp_to_attrs(mp_attr, attr, info->num_attr);

  if (info->num_tuples > 0)
  {
    	*arr = (message **)malloc(sizeof(message *)*(info->num_tuples));
  	if (!*arr) return TBL_FAILURE;
  }

  for (i = 0; i<info->num_tuples; i++)
  {
        v = msg_get(mp_list, "%-m", &(*arr)[i]);
	msg_increfcount((*arr)[i]);
	if (v != 1) return TBL_FAILURE;
  }
  msg_delete(mp_list);

  if (!filter) msg_delete(f);
  return TBL_SUCCESS;
}
