/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_client.h"
#include "table_lib.h"

int t_info(relation, info, attr)
RELNAME relation;
TableInfo *info;
AttDes **attr;
{
  message *mp_info, *mp_attr;
  AttDes *a;
  int n, v;

  n = abcast(t_addrp, WORK_ENTRY, "%d %s", TMSG_INFO, relation,
	 1, "%-m %-m %d",
 	 &mp_info, &mp_attr, &v);
  if (n != 1) return TBL_FAILURE;

  if (v == TBL_SUCCESS)
  {
 	mp_to_info(mp_info, info);
	msg_delete(mp_info);
  	if (attr)
  	    mp_to_attrs(mp_attr, attr, info->num_attr);
	msg_delete(mp_attr);
  }
  return v;  
}
