/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_client.h"
#include "table_lib.h"

int t_create(relation, info, attributes, delete)
RELNAME relation;		/* Relation name			*/

TableInfo *info;	/* Table information				*/
			/* input fields: stable, repl_factor, num_attr	*/
			/* output fields: num_tuples, version 		*/

AttDes	*attributes;		/* attributes information 		*/
int	delete;			/* delete attribute if it already exists */
{
  message *mp;
  AttDes *a;
  int i, version, n, v;

  mp = msg_newmsg();
  for (i = 0; i < info->num_attr; i++) {
	a = &attributes[i];
    	msg_put(mp, "%s %d %d", a->AttName, a->type, a->clientData);
  }
  n = abcast(t_addrp, WORK_ENTRY,
	"%d %s %d %d %d %m %d %d",
 	TMSG_CREATE, relation,
		info->stable, info->repl_factor, info->num_attr,
		mp, delete, random(),
	1, "%d %d", &info->version, &v);
  msg_delete(mp);
  info->num_tuples = 0;
  if (n != 1) return TBL_FAILURE;
  return v;  
}
