/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include "isis.h"
#include "types.h"
#include <stdio.h>

extern int (*basetypecmp3[])();


/* 

   By Mark D. Wood

   routines to facilitate handling sets.  These routines are intended
   for Meta's internal use only.  

   The sn routines take something of type TYPE_SET and convert it to
   type TYPE_ISET.  This form is a structure containing a pointer to
   the original set, a count of the number of elements in the set,
   and a vector of pointers to the elements themselves, kept in
   sorted order; the routine set_index creates this structure.
   The routines iset_inclusion and isetcmp perform do the type
   comparison stuff; the whole rationale behind this alternative
   representation was to enable a faster way of doing set compares.
*/


ISET * set_index(type,set)
int type;
message *set;

{
    PTR *p;
    char * fmt;
    extern char * type_isisfmt();

    int size = cardinality(set,type);
    ISET * iset = (ISET *) malloc(sizeof(ISET) + sizeof(PTR) * size);
    iset->size = size;
    iset->refcnt = 1;
    iset->m_value = set;
    msg_increfcount(set);
    p = &(iset->elm[0]);
    fmt = type_isisfmt(type & TYPE_BASE, FALSE);
    msg_rewind(set);
    for (; size; size--)
      msg_get(set,fmt,p++);
    msg_rewind(set);

    if (iset->size > 1)
      qsort((char *) &(iset->elm[0]),
	    iset->size,
	    sizeof(PTR),
	    basetypecmp3[type & TYPE_BASE]
	    );

    return iset;
}



int iset_inclusion(type,a,b)
int type;
ISET *a,*b;

/* returns TRUE if cardinality of set a is less than or equal to the
   cardinality of set b and every element of a is a member of b. */

{
    register PTR *ap, *bp;
    register int asize, bsize;
    int base_type = type & TYPE_BASE;
    int cmp;

    asize = a->size;
    bsize = b->size;

    if (asize > bsize)
      /* note, strictly speaking this could be true.  If we consider
	 a and b to be just multisets, it is still possible for
	 all elements of a to be elements of b and yet a to have
	 more elements than b because of duplicates */

      return FALSE;

    ap = &(a->elm[0]);
    bp = &(b->elm[0]);

    while (asize) {
	/* asize <= bsize */

	cmp = (*basetypecmp3[base_type])(ap,bp);
	if (cmp < 0) 
	  return FALSE;
	else if (cmp > 0) {
	    bp++; bsize--;
	    if (asize > bsize) return FALSE;
	} else {
	    ap++; asize--;
	    bp++; bsize--;
	    continue;
	}
    }
    return TRUE;
}



int isetcmp(type,relation,a,b)
int relation;
ISET *a,*b;

{
    switch (relation & R_MASK) {
      case R_CMP : fprintf(stderr,"R_CMP on sets not defined!\n");
	exit(-1);
      case R_EQ : return ((a->size == b->size) &&
			  iset_inclusion(type,a,b));
      case R_LT : if (a->size == b->size) return FALSE;
      case R_LE : return iset_inclusion(type,a,b);
      case R_GT : if (a->size == b->size) return FALSE;
      case R_GE : return iset_inclusion(type,b,a);
      case R_NE :
      case R_CHANGE : return ((a->size != b->size) || 
			      !iset_inclusion(type,a,b));
    }
}
	


void free_iset(is)
ISET *is;

{
    if (is && (--is->refcnt == 0)) {
	msg_delete(is->m_value);
	free(is);
    }
}
