/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <sys/time.h>
#include <sys/resource.h>
#include "sm.h"


/* Implementation of process stats sensors.

   By Mark D. Wood
*/

extern GN_STRING sn_class;


int sn_utime(time_p)
long **time_p;

{
    struct rusage rup;
    static long runtime;

    getrusage(RUSAGE_SELF,&rup);
    runtime = rup.ru_utime.tv_sec;
    *time_p = &runtime;
    return 0;
}



int sn_stime(time_p)
long **time_p;

{
    struct rusage rup;
    static long runtime;

    getrusage(RUSAGE_SELF,&rup);
    runtime = rup.ru_stime.tv_sec;
    *time_p = &runtime;
    return 0;
}



int sn_etime(time_p)
long **time_p;

{
    struct rusage rup;
    static long runtime;

    getrusage(RUSAGE_SELF,&rup);
    runtime = rup.ru_utime.tv_sec + rup.ru_stime.tv_sec;
    *time_p = &runtime;
    return 0;
}



int sn_maxrss(size_p)
long **size_p;

{
    struct rusage rup;
    static long size;

    getrusage(RUSAGE_SELF,&rup);
    size = rup.ru_maxrss * getpagesize();
    *size_p = &size;
    return 0;
}

      

int sn_blockio(amount_p)
long **amount_p;

{
    struct rusage rup;
    static long amount;

    getrusage(RUSAGE_SELF,&rup);
    amount = rup.ru_inblock + rup.ru_oublock;
    *amount_p = &amount;
    return 0;
}

      

int sn_pfaults(pfaults_p)
long **pfaults_p;

{
    struct rusage rup;
    static long pfaults;

    getrusage(RUSAGE_SELF,&rup);
    pfaults = rup.ru_minflt + rup.ru_majflt;
    *pfaults_p = &pfaults;
    return 0;
}



sn_rusage(pollfreq)
int pollfreq;

{
    static short donebefore = 0;

    if (donebefore) return;
    donebefore = 1;

    sn_newsensor(sn_maxrss,"maxrss",TYPE_INT,pollfreq);
    sn_newsensor(sn_utime,"utime",TYPE_INT,pollfreq);
    sn_newsensor(sn_etime,"etime",TYPE_INT,pollfreq);
    sn_newsensor(sn_stime,"stime",TYPE_INT,pollfreq);
    sn_newsensor(sn_pfaults,"pfaults",TYPE_INT,pollfreq);
    sn_newsensor(sn_blockio,"blockio",TYPE_INT,pollfreq);
}
