/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <search.h>
#include <strings.h>
#include "isis_errno.h"
#include "sm.h"
#include "sm_err.h"
#include "classes.h"
#include "meta_entries.h"


  /*  The sensor monitor/manager library -- sm_current_val. 

      By Mark D. Wood.
   */


/* library globals */

extern int sm_numsensors;
extern SENSOR *sm_sensors;
extern message *empty_message;	/* empty isis message constant */
extern message *empty_set;
extern address *sm_sensor_address();
extern SENSOR *sm_sensorlookup();

int sm_current_value(sensor,instance,m_value,type)
char *sensor;                   /* in: name of sensor */
char *instance;                 /* in: specific instance */
message **m_value;              /* out: current value */
int *type;                      /* out: type of sensor */

{
    address *gaddr;
    int status;
    char *s_instance;
    SENSOR *sp;
    int nr;

    sp  = sm_sensorlookup(sensor);
    if (!sp)
      return SM_NOTKNOWN;

    gaddr = sm_sensor_address(sp->class,instance);

    *type = sp->type;

    if (!instance ||
	InstanceIsClass(instance) || addr_isnull(gaddr)) {
	if (sp->type & TYPE_SET) {
	    *m_value = empty_set;
	    msg_increfcount(empty_set);
	    msg_increfcount(empty_message);
	} else {
	    *m_value = sp->default_val;
	    msg_increfcount(sp->default_val);
	    msg_rewind(sp->default_val);
	}

        return SM_NOTAVAIL;
    }

    if (((nr=cbcast(gaddr,SN_POLL,"%s%s",sp->name,instance,
               1,"%d%-s%m",
               &status,&s_instance,m_value)) <= 0) || (status < 0)) {

	msg_delete(*m_value);

	if (sp->type & TYPE_SET) {
	    *m_value = empty_set;
	    msg_increfcount(empty_set);
	} else {
	    *m_value = sp->default_val;
	    msg_increfcount(sp->default_val);
	    msg_rewind(sp->default_val);
	}

        if (!nr || (isis_errno == IE_UNKNOWN)) {
            return SM_NOTAVAIL;
        } else if (isis_errno == IE_MISSMATCH) {
            fprintf(stderr,"Bad reply from sensor\n");
            return SM_INTERNAL;
        } else if (!status) {
	    fprintf(stderr,"sensor error %d\n");
	} else if (status < 0) {
	    fprintf(stderr,"sensor returns status %d\n",status);
	} else if (isis_errno) {
            isis_perror("current_val");
            return SM_INTERNAL;
        } else
	    return SM_INTERNAL;
    }
/*    addr_free(gaddr); */
#ifdef DEBUG
    printf("reply from %s %s\n",sensor,s_instance);
#endif
    return status;
}
