/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include "sm.h"
#include "classes.h"
#include "table.h"
#include "meta_entries.h"

/* library globals */

extern void newsensor();
extern void meta_alert();
extern char *set_create();
extern void sensor_failed();

int sm_isis_port = 0;	        /* port number to use */
SENSOR *sm_sensors;             /* pointer to array of sensor info */
int sm_watching = 0;		/* true if sm_init has been called
				   implies that user is committed to
				   calling isis_acceptevents. */
message *empty_message;	        /* the empty message constant */
message *empty_set;	        /* the empty message constant */

int sm_clientof[MAX_NUM_CLASSES]; 

char * running_classes;  /* those classes currently running */

extern char *class_name[];

#ifdef DOTHIS
SENSOR *sm_getsdf();
#endif

address * sm_sensor_address(class,instance)
int class;
char * instance;

{
    GN_STRING name;
    address * gaddr;

    strcpy(name,METANAME);
    strcat(name,class_name[class]);
    if (!instance || InstanceIsClass(instance)) {
	gaddr = pg_lookup(name);
    } else {
	strcat(name,"/");
	strcat(name,instance);
	gaddr = pg_lookup(name);
	if (sm_watching && (pg_rank_all(gaddr,&my_address) == -1))
	  pg_client(gaddr,"");
    }
    return gaddr;
}



void bypass_enable(class)
int class;

{
    GN_STRING name;
    static bypass_on[MAX_NUM_CLASSES];

    if (bypass_on[class])
      return;

    bypass_on[class] = TRUE;
    strcpy(name,"/Meta-BY/");
    strcat(name,class_name[class]);
    pg_join(name,0);
}



void sm_init1(port)
int port;


{
    sm_isis_port = port;

    if (t_tableinit(sm_isis_port) != TBL_SUCCESS) {
	fprintf(stderr,"table system failure!\n");
	exit(-1);
    }
    empty_message = msg_newmsg();
    empty_set = msg_newmsg();
    type_pack(TYPE_SET,empty_set,SM_VALFLD,&empty_message);
    isis_init(sm_isis_port);
    isis_start_done();
}



void sm_init(port)
int port;


{
    running_classes  = set_create();
    isis_entry(SM_ALERT,meta_alert,"alert");
    isis_entry(SM_NEWSENSOR,newsensor,"newsensor");
    isis_task(sensor_failed,"sensor_failed");
    sm_init1(port);
    pg_join("/meta/sm",0);
    sm_watching = 1;
}
