/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

/*
  Set abstract data type: functions to create a multiset, add and
  delete elements, and test for membership.

  By Mark D. Wood
*/


#define BUCKETSIZE 10
#define HASHTABLESIZE 103
#define NULL 0



struct bucket {
    unsigned value[BUCKETSIZE];
    struct bucket * next;
};


typedef struct bucket *SET[HASHTABLESIZE];

static hash(value)
unsigned value;

{
    return ((value * value) >> 3) % HASHTABLESIZE;
}



char *set_create()

{ 
    SET * set;

    set = (SET *) malloc(sizeof(SET));
    bzero(set,sizeof(SET));
    return (char *) set;
}



set_member(set,value)
char * set;
unsigned value;

{
    register struct bucket *bp;
    register int i;

    for (bp = (*((SET *) set))[hash(value)];
	 bp; bp = bp->next)  {
	for (i=0; (i<BUCKETSIZE) && ((bp->value)[i]); i++) {
	    if (bp->value[i] == value)
	      return 1;
	}
    }
    return 0;
}
	 


void set_add(set,value)
char *set;
unsigned int value;

/* adds value to the (multi)set pointed to by set */

{
    register struct bucket *bp, ** prev;
    register int i;
    int hv;

    hv = hash(value);
    for (prev = &(*((SET *) set))[hv],bp = *prev;
	 bp && bp->next;
	 prev = &(bp->next), bp = *prev)
      ;

    /* bp now points to last bucket in list of buckets */

    if (bp) {
	for (i=0; (i < BUCKETSIZE) && (bp->value)[i]; i++)
	  ;
	/* look for empty spot (containing zero) */
	if (i < BUCKETSIZE) {
	    bp->value[i] = value;
	    return;
	} else
	  prev = &(bp->next);
    }
    *prev = (struct bucket *) malloc(sizeof(struct bucket));
    bzero(*prev,sizeof(struct bucket)); 
    (*prev)->value[0] = value;
}



void set_delete(set,value)
char *set;
unsigned int value;

/* deletes (a copy of) value from the (multi)set pointed to by set */

{
    register struct bucket *bp, ** prev;
    register struct bucket *bp1, ** prev1;
    register int i,j;
    int hv;

    /* first find the element, then overwrite it with the
       last element */

    hv = hash(value);
    for (prev = &(*((SET *) set))[hv],bp = *prev;
	 bp;
	 prev = &(bp->next), bp = *prev) {
	for (i=0; (i < BUCKETSIZE) && (bp->value)[i]; i++) {
	    if (bp->value[i] == value) {
		for (bp1 = bp, prev1 = prev;
		     bp1->next;
		     prev1 = &(bp1->next), bp1 = bp1->next)
		  ;
		for (j=BUCKETSIZE - 1; j; j--)
		  if (bp1->value[j])
		    break;
		bp->value[i] = bp1->value[j];
		bp1->value[j] = 0;
		if (!j) {
		    *prev1 = NULL;
		    free(bp1);
		}
		return;
	    }
	}
    }
}
