/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <strings.h>
#include "sm.h"
#include "sm_err.h"
#include "meta_entries.h"

/* Actuator manager.  Accepts rpc requests to call actuators;
   allows library user to define actuators:

   global routines: 
     act_init -- called to initialize
     act_newactuator -- called to declare a new actuator
   isis entry:
     act -- accepts/processes rpc requests.

   By Mark D. Wood
*/


#define MAX_NUMACTUATORS 32


extern short active_replica;
extern address * troupe_addr;



/* globals used by actuators */


static char my_name[INSTANCE_LENGTH];
static char *a_name[MAX_NUMACTUATORS];
static int (*a_func[MAX_NUMACTUATORS])();
static int a_type[MAX_NUMACTUATORS];
static int num_running[MAX_NUMACTUATORS];
static short needexclusion[MAX_NUMACTUATORS];
static condition wcond[MAX_NUMACTUATORS];
static int num_actuators = 0;



static int lookup(name)
char *name;

{
    register a_num;
    for (a_num = 0; a_num < num_actuators; a_num++)
      if (!strcmp(a_name[a_num],name)) return a_num;
    return -1;
}



static void act(request)
message *request;

{
    message *m_value;
    char *actuator;
    long status;
    int a_num;
    PTR value;
    int variety;
    
    if (!active_replica) return;

    msg_get(request,"%-s%-m%d",&actuator,&m_value,&variety);
    a_num = lookup(actuator);
    if (a_num < 0) {
	status = SM_NOTKNOWN;
    } else {
	value = NULL;
	type_unpack(a_type[a_num],m_value,SM_VALFLD,&value);
#ifdef DEBUG
	printf("Setting %s to ",actuator);
	type_fprint(stdout,a_type[a_num],value);
	printf("\n");
#endif

	if (needexclusion[a_num]) {
	    num_running[a_num]++;
	    if (num_running[a_num] > 1)
	      t_wait(&wcond[a_num]);
	    status = (*a_func[a_num])(value);
	    num_running[a_num]--;
	    if (num_running)
	      t_sig(&wcond[a_num],0);
	} else
	  status = (*a_func[a_num])(value);
    }

    if (variety == ACT_SYNC) {
	reply(request,"%d%s",(long) status,my_name);
    } else {
	/* variety == ACT_ASYNC */
	int eid;

	msg_get(request,"%d",&eid);
	abcast(msg_getsender(request),SM_ALERT,
	       "%d%d%s%d",META_ACTUATOR,(long) status, my_name, eid,0);
	/* could have actuator return result (i.e., an m_value) */
    }
}




act_init(class,isisport)
char *class;
int isisport;

{
    static donebefore = 0;

    if (donebefore) return;
    donebefore = 1;
    isis_init(isisport);
    sm_shortname(my_name,my_host,sizeof(my_name));
    isis_entry(SM_ACT,act,"act_poll");
    meta_name(class,my_name);   
}




int act_newactuator(function,name,type,mutex)
int (*function)();
char *name;
int type;
int mutex;

{
    extern char *strdup();

    if (num_actuators >= MAX_NUMACTUATORS)
      return -1;
    a_func[num_actuators] = function;
    a_type[num_actuators] = type;
    a_name[num_actuators] = strdup(name);
    wcond[num_actuators] = 0;
    needexclusion[num_actuators] = mutex;
    return num_actuators++;
}
