/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#define TYPE_INT 0
#define TYPE_REAL 1
#define TYPE_STRING 2

#define NUM_TYPES 3

#define TYPE_BASE 15
#define TYPE_SET 16
#define TYPE_INTERVAL 32

typedef long int_interval[2];
typedef double real_interval[2];

#define TYPE_MAXSIZE 256

#define SM_VALFLD 1

#ifndef PROLOG
typedef void * PTR;
#endif

#ifndef ISSOURCE
extern char *type_name[];
extern int (*ascii_to_basetype[])();
#endif

typedef message * SET;

/* relational operators.  R_CMP is used internally to indicate that
   the compare function should return -1, 0, or 1 depending on whether
   the second value is less than, equal, or greater than the first
   value.  The values for the other relational operators are picked
   so that by negating (and ANDing with the mask) you will get the
   value for the negative of the operator; this important relationship
   is used in type_cmp */

#define R_CMP 0
#define R_EQ 1
#define R_GT 2
#define R_GE 3
#define R_LT 4
#define R_LE 5
#define R_NE 6
#define R_CHANGE 7
#define R_MASK 0x7

#define R_CARD 8
#define R_POSSIBLE 16

#ifdef DOTHIS
#define type_unpack(type,msg,column,val) \
  msg_getfld(msg,column + 1,NULL, \
	     type_isisfmt(type,*(val)), (*(val)) ? (int) *(val) : (int) val)

#define type_pack(type,msg,column,val) \
  msg_putfld(msg,column+1,type_isisfmt(type,TRUE),val)
#endif


#define set_pack(type,set,val) \
  msg_put(*set,type_isisfmt(type & TYPE_BASE,TRUE),val)

#define set_unpack(type,set,val) \
  msg_get(*set,type_isisfmt(type & TYPE_BASE,*val), \
	  (*(val)) ? (int) *(val) : (int) val)

struct iset {
    int refcnt;
    int size;
    message *m_value;
    PTR elm[1];
};

typedef struct iset ISET;
