/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

/* Table Manager Interface */

#define TBL_MAXNAME         37 
#define TBL_MAXATTRS        128

typedef char RELNAME[TBL_MAXNAME + 1];

typedef struct{
     char AttName[TBL_MAXNAME + 1];   	/* name of attribute            */
     int type;                    	/* index into type table	*/
     int  clientData;             	/* for client's use		*/
} AttDes; 

typedef struct{
	int stable;
	int repl_factor;
	int num_attr;
	int num_tuples;
	int version;
} TableInfo;


#define TRUE 			1
#define FALSE 			0

/* defines for table module */
#define TBL_NOSORT 		(-1)
#define TBL_SORTALL 		(-2)
#define TBL_FIRST_TUPLE 	(-1)

/* return codes           */
#define TBL_SUCCESS 		1
#define TBL_FAILURE 		(-1)
#define TBL_TABLE_NOEXIST 	(-2)
#define TBL_TABLE_EXIST 	(-3)
#define TBL_TUPLE_DUPLICATE	(-4)
#define TBL_TUPLE_NOEXIST	(-5)
#define TBL_COL_NOEXIST		(-6)
#define TBL_MIN_CODE 		(-6)

/* sysrel name */
#define TBL_SYSREL	"*systable*"
