/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include "isis.h"
#include "types.h"

#define SDF "./sdf"
#define METANAME "/meta/"
#define CLASS_DELIM ':'

#ifndef ISISPORT
#define ISISPORT "ISISPORT"
#endif

#define MAXSENSORS 32
#define NAME_LENGTH 32
#define INSTANCE_LENGTH 64

#define SN_CHK_ALL -1

typedef char GN_STRING[NAME_LENGTH];

struct sensor {
    char *name;
    int type;
    int class;
    message * default_val;
};

typedef struct sensor SENSOR;

struct event {
    struct event *prev,*next;
    int variety;
    unsigned int priority,class;
    int relation;
    SENSOR *sp;
    char * instance;
    void (*func)();
    address sn_addr;
    message *await_val;
    struct occurrence *waiting;
    int delete;
    int num_running;
    int uid;
};

typedef struct event EVENT;

struct occurrence {
    struct occurrence *prev,*next;
    EVENT * eid;
    message * m_value;
    message * msg;
    int status;
    char * instance;
    int is_waiting;
    int priority;		/* duplicated from EVENT for ease */
    struct occurrence *next_waiting,*prev_waiting;
};

typedef struct occurrence OCCURRENCE;


#define SM_ALERTONCE 0x100
#define SM_ALERTINIT 0x200
#define SM_STOPONFAIL 0xC00	/* implies ALERTONFAIL */
#define SM_ALERTONFAIL 0x400

#define InstanceIsClass(i) (!strcmp(i,"*"))


#define ACT_ASYNC 1
#define ACT_SYNC 0
#define META_ACTUATOR 0
#define META_SENSOR 1
