/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#define DITROFF

#include <stdio.h>

#define PS	14
#define SCALE	0.7

int nstr, width, height;

do_line(){
	int x1, y1, x2, y2;

	scanf("%d %d %d %d\n", &x1, &y1, &x2, &y2);
	printf("newpath %d %d %d %d line stroke\n",
					x1, height - y1, x2, height - y2);
}

do_circle(){
	int x, y, w, h;

	scanf("%d %d %d %d\n", &x, &y, &w, &h);
	w /= 2; h /= 2;
	x += w; y = height - y - h;
	printf("newpath %d %d %d %d ellipse stroke\n", x, y, w, h);
}

do_string(){
	int x, y, w, h;
	char fmt[16], buf[128], c, *p = buf;

	scanf("%d %d %d %d %s ", &x, &y, &w, &h, fmt);
	while ((c = getchar()) != '\n') {
		if (c == '(' || c == ')' || c == '\\')
			*p++ = '\\';
		*p++ = c;
	}
	*p = 0;
	printf("/str%d { %d %d moveto\n", nstr++, x, height - y);
	switch (*fmt) {
	case 'l':
		printf("4 ");
		break;
	case 'c':
		printf("%d (%s) stringwidth pop sub 2 div\n", w, buf);
		break;
	case 'r':
		printf("%d (%s) stringwidth pop sub 4 sub\n", w, buf);
		break;
	default:
		fprintf(stderr, "bad format in string\n");
	}
	printf("%d %d sub 2 div descent add rmoveto (%s) } def\n", h, PS, buf);
}

do_rectangle(){
	int x, y, w, h;

	scanf("%d %d %d %d\n", &x, &y, &w, &h);
	printf("newpath %d %d moveto\n", x, height - y);
	printf("%d 0 rlineto 0 %d rlineto %d 0 rlineto\n", w, -h, -w);
	printf("closepath .7 setgray fill 0 setgray\n");
}

do_poly(){
	int n, x, y;

	scanf("%d %d %d", &n, &x, &y);
	printf("newpath %d %d moveto\n", x, height - y);
	while (--n) {
		scanf(" %d %d", &x, &y);
		printf("%d %d lineto\n", x, height - y);
	}
	printf("closepath fill\n");
	getchar();
}

main(){
	int type, i;
	long now;

	time(&now);
	scanf("%d %d\n", &width, &height);
#ifdef DITROFF
	printf("%%PB\n");
#else
	printf("%%!PS\n");
#endif
	printf("%%%%CreationDate: %s", ctime(&now));
	printf("%%%%BoundingBox: 0 0 %d %d\n",
			(int) (width * SCALE), (int) (height * SCALE));
	printf("%%%%EndComments\n");
	printf("/Times-Roman findfont %d scalefont setfont\n", PS);
	printf("/ylo currentfont /FontBBox get 1 get def\n");
	printf("/yhi currentfont /FontBBox get 3 get def\n");
	printf("/descent ylo %d mul ylo yhi sub div def\n", PS);
	printf("/line { moveto lineto } bind def\n");
	printf("/ellipsedict 8 dict def ellipsedict /mtrx matrix put\n");
	printf("/ellipse { ellipsedict begin /yrad exch def /xrad exch def\n");
	printf("/y exch def /x exch def /savematrix mtrx currentmatrix def\n");
	printf("x y translate xrad yrad scale 0 0 1 0 360 arc\n");
	printf("savematrix setmatrix end } bind def\n");
	printf("1 setlinewidth %g %g scale\n", SCALE, SCALE);
	printf("%%%%EndProlog\n");
	while ((type = getchar()) != EOF) {
		getchar();
		switch (type) {
		case 'l':	do_line();	break;
		case 'c':	do_circle();	break;
		case 's':	do_string();	break;
		case 'r':	do_rectangle();	break;
		case 'p':	do_poly();	break;
		default:
			fprintf(stderr, "format error\n");
			exit(1);
		}
	}
	for (i = 0; i < nstr; i++)
		printf("str%d show\n", i);
#ifdef DITROFF
	printf("PE\n.\n");
#endif
}
