/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This is the clock sensor.  It is UNIX dependent, as it calls time() and
 * fork().  It forks off a process that sends the sensor a message every
 * second.  When the message is received, the sensor puts the current time
 * in the appropriate database entry "clock/value".
 */

#include <signal.h>

clk_message(){
	long time(), now;

	time(&now);
	db_numstore("clock", "value", (int) now);
}

main(){
	mag_init("clock");
	/* initialize the time
	 */
	clk_message();

	/* Fork off a separate process to update the clock.
	 */
	win_receive(clk_message);
	if (fork() == 0) {
		signal(SIGINT, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
		for (;;) {
			if (getppid() < 2)
				_exit(0);
			win_message();
			sleep(1);
		}
	}

	win_main_loop();
	mag_exit(0);
}
