/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#define SCALE	8192		/* Used to avoid doubles */

struct object {			/* description of a widget */
	struct value *o_valname, *o_valtype, *o_valrecord;
	char *o_name;			/* it's name */
	char *o_type;			/* it's type */
	char *o_record;			/* where to get data from */
	int o_x, o_y;			/* position */
	int o_width, o_height;		/* size */
	int o_level;			/* level of recursion */
};

struct window {			/* window related info */
	int w_locked;			/* window locked */
	int w_mapped;			/* window mapped */
	struct object w_object;		/* window info */

/* X windows part */
	Window w_win;			/* the window */
	XWindowAttributes w_wa;		/* its attributes */
	Pixmap w_pm;			/* shadow copy of contents */
	GC w_gc, w_clrgc, w_invgc;	/* some useful graphical contexts */
};

#define w_name		w_object.o_name
#define w_type		w_object.o_type
#define w_record	w_object.o_record
#define w_x		w_object.o_x
#define w_y		w_object.o_y
#define w_width		w_object.o_width
#define w_height	w_object.o_height
