/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This file contains various (postfix) operations on strings.
 */

#include "magic.h"
#include "value.h"
#include "expr.h"

struct value *x_pop();

/* Take a string of the stack, and quote it.
 */
str_quote(c)
struct context *c;
{
	struct value *v = x_pop(c);
	int n = 3;
	char *p, *q, *r, *s;

	if ((s = val_str(v)) == 0) {
		x_dirpush(v);
		return;
	}
	for (p = s; *p != 0; p++)
		if (*p == '\\' || *p == '"')
			n++;
	q = r = MAG_MALLOC(n, char);
	*q++ = '"';
	for (p = s; *p != 0; p++) {
		if (*p == '\\' || *p == '"')
			*q++ = '\\';
		*q++ = *p;
	}
	*q++ = '"';
	*q = 0;
	x_dirpush(val_pstr(r, val_seq(v)));
	val_free(v);
}

/* Take two strings of the stack and compare them a la strcmp().
 */
str_cmp(c)
struct context *c;
{
	struct value *v1, *v2;
	int val;
	char *s1, *s2;

	v2 = x_pop(c);
	v1 = x_pop(c);
	s1 = val_str(v1);
	s2 = val_str(v2);
	if (s1 == 0 && s2 == 0)
		val = 0;
	else if (s1 == 0)
		val = -1;
	else if (s2 == 0)
		val = 1;
	else
		val = strcmp(s1, s2);
	x_numpush(val < 0 ? -1 : (val == 0 ? 0 : 1),
					m_max(val_seq(v1), val_seq(v2)));
	val_free(v1);
	val_free(v2);
}

/* Calculate the length of a string.
 */
str_length(c)
struct context *c;
{
	struct value *v = x_pop(c);

	if (val_null(v))
		x_dirpush(v);
	else {
		x_numpush(strlen(val_str(v)), val_seq(v));
		val_free(v);
	}
}

/* Pop two strings of the stack and push the concatenation.
 */
str_concat(c)
struct context *c;
{
	struct value *v1, *v2;
	char *s1, *s2, *buf;

	v1 = x_pop(c);
	v2 = x_pop(c);
	s1 = val_str(v1);
	s2 = val_str(v2);
	if (s1 == 0) s1 = "";
	if (s2 == 0) s2 = "";
	buf = MAG_MALLOC(strlen(s1) + strlen(s2) + 1, char);
	sprintf(buf, "%s%s", s1, s2);
	x_dirpush(val_pstr(buf, m_max(val_seq(v1), val_seq(v2))));
	val_free(v1);
	val_free(v2);
}

/* Pop three strings of the stack, a, b, and c, and push acb.
 */
str_concat3(c)
struct context *c;
{
	struct value *v1, *v2, *v3;
	char *s1, *s2, *sep, *buf;

	v3 = x_pop(c);
	v2 = x_pop(c);
	v1 = x_pop(c);
	s1 = val_str(v1);
	s2 = val_str(v2);
	sep = val_str(v3);
	if (s1 == 0) s1 = "";
	if (s2 == 0) s2 = "";
	if (sep == 0) sep = "";
	buf = MAG_MALLOC(strlen(s1) + strlen(sep) + strlen(s2) + 1, char);
	sprintf(buf, "%s%s%s", s1, sep, s2);
	x_dirpush(val_pstr(buf,
			m_max(m_max(val_seq(v1), val_seq(v2)), val_seq(v3))));
	val_free(v1);
	val_free(v2);
	val_free(v3);
}

/* Register all string operations.
 */
str_start(){
	x_register("$quote", str_quote);
	x_register("$cmp", str_cmp);
	x_register("$length", str_length);
	x_register("$concat", str_concat);
	x_register("$concat3", str_concat3);
}
