/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/* This file contains a set of standard postfix functions stored in the
 * std.func record.  These are:
 *
 *	attr	arguments	description
 *
 *	diff	rec attr	differentiate <rec, attr> over time
 *	min	rec attr t	minimum over last t seconds
 *	max	rec attr t	maximum over last t seconds
 *	int	rec attr t	integrate over last t seconds
 *	get	rec attr t	get value t seconds ago
 *
 * For example, "r a 10 std.func max # $eval" returns the minimum of the
 * values in record r, attribute a over the last 10 seconds.
 */

std_diff(){
	db_store("std.func", "diff", "a := r := %r %a # x := %x %r %a %x $seq 1 - $get y := %y - clock value %x $seq $get clock value %y $seq $get - /");
}

std_min(){
	db_store("std.min", "loop", "clock value %v $seq $get now := %now %start > %r %a %v $seq 1 - $get v := %v %result < %v %result ? result := std.min loop # %result ? $eval");
	db_store("std.func", "min", "std.func init # $eval %v result := std.min loop # $eval");
}

std_max(){
	db_store("std.max", "loop", "clock value %v $seq $get now := %now %start > %r %a %v $seq 1 - $get v := %v %result > %v %result ? result := std.max loop # %result ? $eval");
	db_store("std.func", "max", "std.func init # $eval %v result := std.max loop # $eval");
}

std_get(){
	db_store("std.get", "loop", "clock value %v $seq $get now := %now %start > %r %a %v $seq 1 - $get v := std.get loop # %v ? $eval");
	db_store("std.func", "get", "std.func init # $eval std.get loop # $eval");
}

std_integrate(){
	char *p = "std.integrate";

	mag_append(p, "%now prev := std.func time # $eval", 0);
	mag_append(p, "%now %start < %start %now ? now :=", 0);
	mag_append(p, "%result %v %prev %now - * + result :=", 0);
	mag_append(p, "std.func cond # $eval", 0);
	mag_append(p, "std.integrate loop # %result ? $eval", 0);
	db_store(p, "loop", "std.integrate \"$entry\" $list std.integrate N # 1 - \"\\\" \\\" $concat3\" $iter $eval");
	db_store("std.func", "int", "std.func init # $eval 0 result := std.integrate loop # $eval");
}

std_init(){
	db_store("std.func", "init", "t := a := r := clock value # now := %now %t - start := %r %a # v :=");
	db_store("std.func", "time", "clock value %v $seq $get now :=");
	db_store("std.func", "cond", "%now %start > %r %a %v $seq 1 - $get v :=");
	std_diff();
	std_min();
	std_max();
	std_get();
	std_integrate();
}
