/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This implements data base selections.  The result of selections should
 * really be cached, but that hasn't been implemented yet.
 */

#include "magic.h"
#include "value.h"
#include "expr.h"

struct value *x_pop(), *mag_index();

extern struct value **x_sp;

struct context sel_ctx;
struct value *sel_crit;

sel_test(ent)
struct value *ent;
{
	double x_dblpop(), val;

	sel_ctx.c_entry = ent;
	x_do(&sel_ctx, sel_crit);
	val = x_dblpop(&sel_ctx);
	x_cleanup(&sel_ctx);
	while (x_sp != sel_ctx.c_top)
		val_free(*x_sp++);
	return val != 0;
}

sel_count(c)
struct context *c;
{
	struct value *tmp_crit, *r, *ent;
	char *rec;
	int i, N, count = 0;
	struct context tmp_ctx;

	tmp_ctx = sel_ctx;
	tmp_crit = sel_crit;
	sel_crit = x_pop(c);
	r = x_pop(c);
	if (sel_crit == 0 || (rec = val_str(r)) == 0)
		x_null(c);
	else {
		db_numretrieve(rec, "N", &N);
		x_copy(c, &sel_ctx);
		for (i = 0; i < N; i++) {
			ent = mag_index(rec, i);
			if (sel_test(ent))
				count++;
			val_free(ent);
		}
		x_numpush(count, val_seq(r));
	}
	val_free(r);
	val_free(sel_crit);
	sel_crit = tmp_crit;
	sel_ctx = tmp_ctx;
}

sel_select(c)
struct context *c;
{
	struct value *tmp_crit, *r, *ent;
	char *rec;
	int i, index, N;
	struct context tmp_ctx;

	tmp_ctx = sel_ctx;
	tmp_crit = sel_crit;
	sel_crit = x_pop(c);
	index = x_numpop(c);
	r = x_pop(c);
	if (sel_crit == 0 || (rec = val_str(r)) == 0)
		x_null(c);
	else {
		db_numretrieve(rec, "N", &N);
		x_copy(c, &sel_ctx);
		for (i = 0; i < N; i++) {
			ent = mag_index(rec, i);
			if (sel_test(ent) && index-- == 0) {
				x_dirpush(ent);
				break;
			}
			val_free(ent);
		}
		if (i == N)
			x_null(c);
	}
	val_free(r);
	val_free(sel_crit);
	sel_crit = tmp_crit;
	sel_ctx = tmp_ctx;
}

sel_start(){
	x_register("$selcnt", sel_count);
	x_register("$select", sel_select);
}
