/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This implements a scroll-bar.  Maybe this can be merged with containers
 * some day?
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

int scroll_offset;

scroll_getinfo(o, N, start, number, height)
struct object *o;
int *N, *start, *number, *height;
{
	char *rec;

	db_retrieve(o->o_record, "record", &rec);
	if (rec == 0)
		return 0;
	db_numretrieve(rec, "N", N);
	MAG_FREE(rec);
	if (*N == 0)
		return 0;
	db_numretrieve(o->o_record, "start", start);
	db_numretrieve(o->o_record, "number", number);
	if (*number > *N)
		*number = *N;
	if (*start < 0)
		*start = 0;
	else if (*start > *N - *number)
		*start = *N - *number;
	if ((*height = *number * o->o_height / *N - 1) <= 0)
		*height = 1;
	return 1;
}

scroll_press(o, x, y, count)
struct object *o;
{
	int N, start, number, pos, height;

	if (!scroll_getinfo(o, &N, &start, &number, &height))
		return;
	pos = start * o->o_height / N + 1;
	if (y < pos) {
		start = y * N / o->o_height;
		scroll_offset = 0;
	}
	else if (y > pos + height) {
		start = y * N / o->o_height - number;
		scroll_offset = height;
	}
	else
		scroll_offset = y - pos;
	db_numstore(o->o_record, "start", start);
}

scroll_track(o, x, y)
struct object *o;
{
	int N, start, number, height;

	if (!scroll_getinfo(o, &N, &start, &number, &height))
		return;
	if ((y -= scroll_offset) < 0)
		y = 0;
	else if (y > o->o_height - height)
		y = o->o_height - height;
	start = y * N / o->o_height;
	db_numstore(o->o_record, "start", start);
}

scroll_draw(w, o)
struct window *w;
struct object *o;
{
	int N, start, number, pos, height;

	if (!scroll_getinfo(o, &N, &start, &number, &height))
		return;
	pos = o->o_y + start * o->o_height / N + 1;
	win_fillrect(w, o->o_x + 1, pos, o->o_width - 1, height);
}
