/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"
#include "value.h"

#define WIDTH		600
#define HEIGHT		150

/* Create the sensor window.
 */
meta_sensor_cold(){
	char *wid, *mag_new(), *pic_new();

	mag_picture("meta.sensor.win", "meta sensor", "meta sensor",
						WIDTH, HEIGHT, 0);

	wid = mag_new("meta.sensor.tab");
	db_store(wid, "sensor", "sensor");
	db_store(wid, "instance", "instance");
	db_store(wid, "relation", "relation");
	db_store(wid, "value", "value");
	MAG_FREE(wid);
	mag_append("meta.sensor.tab", "meta.sensor", 0);
	wid = pic_new("meta sensor", "table", "meta.sensor.tab",
					10, 10, WIDTH - 20, 50, 1, 1);
	tbl_column(wid, "sensor", 1, 0, "c", (char *) 0);
	tbl_column(wid, "instance", 1, 0, "c", (char *) 0);
	tbl_column(wid, "relation", 1, 0, "c", (char *) 0);
	tbl_column(wid, "value", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	wid = mag_new("meta.sensor.go");
	db_store(wid, "text", "go");
	MAG_FREE(wid);
	wid = pic_new("meta sensor", "table", "meta.sensor.go",
						10, 75, 40, 40, 0, 0);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
	MAG_FREE(pic_new("meta sensor", "menu", "meta.sensor.sel",
						10, 75, 40, 40, 1, 1));
	db_numstore("meta.sensor.sel", "N", 1);

	mag_append("meta.sensor.output", "meta.sensor", 0);
	db_store("meta.sensor", "error", "fill in table");
	wid = pic_new("meta sensor", "table", "meta.sensor.output",
					60, 75, WIDTH - 120, 40, 1, 1);
	tbl_column(wid, "error", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	wid = mag_new("meta.sensor.done");
	db_store(wid, "text", "done");
	MAG_FREE(wid);
	wid = pic_new("meta sensor", "table", "meta.sensor.done",
					WIDTH - 50, 75, 40, 40, 0, 0);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
	wid = pic_new("meta sensor", "container", "meta sensor",
					WIDTH - 50, 75, 40, 40, 1, 1);
	db_numstore(wid, "interval", 1);
	db_store(wid, "attr", "mapped");
	MAG_FREE(wid);
}

/* Create the actuator window.
 */
meta_actuator_cold(){
	char *wid;

	mag_picture("meta.actuator.win", "meta actuator", "meta actuator",
						WIDTH, HEIGHT, 0);

	wid = mag_new("meta.actuator.tab");
	db_store(wid, "record", "record");
	db_store(wid, "attr", "attribute");
	db_store(wid, "actuator", "actuator");
	db_store(wid, "instance", "instance");
	MAG_FREE(wid);
	mag_append("meta.actuator.tab", "meta.actuator", 0);
	wid = pic_new("meta actuator", "table", "meta.actuator.tab",
					10, 10, WIDTH - 20, 50, 1, 1);
	tbl_column(wid, "record", 1, 0, "c", (char *) 0);
	tbl_column(wid, "attr", 1, 0, "c", (char *) 0);
	tbl_column(wid, "actuator", 1, 0, "c", (char *) 0);
	tbl_column(wid, "instance", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	wid = mag_new("meta.actuator.go");
	db_store(wid, "text", "go");
	MAG_FREE(wid);
	wid = pic_new("meta actuator", "table", "meta.actuator.go",
						10, 75, 40, 40, 0, 0);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
	MAG_FREE(pic_new("meta actuator", "menu", "meta.actuator.sel",
						10, 75, 40, 40, 1, 1));
	db_numstore("meta.actuator.sel", "N", 1);

	mag_append("meta.actuator.output", "meta.actuator", 0);
	db_store("meta.actuator", "error", "fill in table");
	wid = pic_new("meta actuator", "table", "meta.actuator.output",
					60, 75, WIDTH - 120, 40, 1, 1);
	tbl_column(wid, "error", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);

	wid = mag_new("meta.actuator.done");
	db_store(wid, "text", "done");
	MAG_FREE(wid);
	wid = pic_new("meta actuator", "table", "meta.actuator.done",
					WIDTH - 50, 75, 40, 40, 0, 0);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
	wid = pic_new("meta actuator", "container", "meta actuator",
					WIDTH - 50, 75, 40, 40, 1, 1);
	db_numstore(wid, "interval", 1);
	db_store(wid, "attr", "mapped");
	MAG_FREE(wid);
}

/* Create the sensor and actuator windows.
 */
meta_cold(){
	meta_sensor_cold();
	meta_actuator_cold();
}
