/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This is the dump window.  It is never actually displayed currently
 * since there is no window update while dumping.  When mapped, it
 * checkpoints the data base and unmappes itself.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

#define WIDTH		200
#define HEIGHT		100

char *pic_new();
struct value **mes_ok();

/* This routine is invoked when the window is mapped.  Checkpoint the
 * data base and unmap.
 */
struct value **dump_select(req)
struct value **req;
{
	if (val_int(req[4]) != 0) {
		db_numstore("dump", "mapped", 0);
		db_checkpoint();
	}
	return mes_ok();
}

/* Create the dump window.  It's never actually displayed currently, so
 * I don't know what it looks like.
 */
dump_init(){
	char *wid;

	mag_picture("dump.win", "dump", "dump", WIDTH, HEIGHT, 0);

	mag_append("dump.output", "dump.err", 0);
	db_store("dump.err", "text", "dumping");
	wid = pic_new("dump", "table", "dump.output",
				10, 10, WIDTH - 20, HEIGHT - 20, 1, 1);
	tbl_column(wid, "text", 1, 0, "c", "ro");
	MAG_FREE(wid);
}

/* Set a watch on the mapped attribute of the window.
 */
dump_start(){
	mes_subscribe("dump_select", dump_select);
	watch_specify(V_NULL, "dump_select", "dump", "mapped");
}
