/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This file contains all kinds of stuff to initialize data bases.
 */

#include <math.h>
#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

#define WIDTH		100
#define HEIGHT		250
#define PI		3.1415927

/* This routine builds a menu containing all the windows that currently
 * exist.  By selecting an entry, the corresponding window gets mapped
 * or unmapped.
 */
mag_menu(){
	char *wid, *pic_new();

	mag_picture("menu.win", "menu", "cancel", WIDTH, HEIGHT, 0);

	wid = pic_new("menu", "table", "control", 0, 0, WIDTH, HEIGHT, 0, 0);
	tbl_column(wid, "descr", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	MAG_FREE(pic_new("menu", "menu", "control",
						0, 0, WIDTH, HEIGHT, 0, 1));
}

/* This routine builds a picture widget that represents a clock.  The time
 * is retrieved from clock/value.
 */
mag_clock(){
	char *wid;
	double s, c, b, e;
	int i, x = SCALE / 2, y = SCALE / 2;

	db_store("clock", "ctime",  "#clock value # $time");
	db_store("clock", "hour",
	   "#clock value # $local_hour 12 % $pi * 6 / clock minute # 12 / +");
	db_store("clock", "minute", "#clock value # 60 $div 60 % $pi * 30 /");
	db_store("clock", "second", "#clock value # 60 % $pi * 30 /");

	/* draw hands
	 */
	wid = pic_new("clock", "line", (char *) 0,
					SCALE / 2, SCALE / 2, 0, 0, 0, 0);
	db_store(wid, "width", "# clock second # $sin 3275 *");
	db_store(wid, "height", "# clock second # $cos -3275 *");
	MAG_FREE(wid);
	wid = pic_new("clock", "hand", (char *) 0,
					SCALE / 2, SCALE / 2, 0, 0, 0, 0);
	db_store(wid, "width", "# clock minute # $sin 2725 *");
	db_store(wid, "height", "# clock minute # $cos -2725 *");
	db_dblstore(wid, "thickness", 0.3);
	MAG_FREE(wid);
	wid = pic_new("clock", "hand", (char *) 0,
					SCALE / 2, SCALE / 2, 0, 0, 0, 0);
	db_store(wid, "width", "# clock hour # $sin 2048 *");
	db_store(wid, "height", "# clock hour # $cos -2048 *");
	db_dblstore(wid, "thickness", 0.4);
	MAG_FREE(wid);

	/* draw plate
	 */
	b = SCALE * 0.46;
	e = SCALE * 0.49;
	for (i = 0; i < 60; i++) {
		if (i % 5 == 0)
			continue;
		sincos(i * PI / 30, &s, &c);
		line_append("clock",	(int) (x + s * b), (int) (y - c * b),
					(int) (x + s * e), (int) (y - c * e)); 
	}
	b = SCALE * 0.44;
	e = SCALE * 0.50;
	for (i = 0; i < 12; i++) {
		sincos(i * PI / 6, &s, &c);
		line_append("clock",	(int) (x + s * b), (int) (y - c * b),
					(int) (x + s * e), (int) (y - c * e)); 
	}
}

/* This routine is called to initialize a window.  The window contains a
 * picture widget which is added to the control list.
 */
mag_picture(pic, rec, descr, width, height, mapped)
char *pic, *rec, *descr;
{
	char buf[8];
	int N;

	db_numretrieve("control", "N", &N);
	mag_strnum(buf, N);
	db_store("control", buf, pic);
	db_numstore("control", "N", N + 1);
	db_store(pic, "type", "picture");
	db_store(pic, "record", rec);
	db_store(pic, "descr", descr);
	db_numstore(pic, "x", 0);
	db_numstore(pic, "y", 0);
	db_numstore(pic, "width", SCALE);
	db_numstore(pic, "height", SCALE);
	db_numstore(rec, "width", width);
	db_numstore(rec, "height", height);
	db_numstore(rec, "mapped", mapped);
}

/* At startup you can arrange that some messages are sent automatically.
 * This routine will make mes to be sent to dest at startup.
 */
mag_initmes(dest, mes)
struct value *dest, **mes;
{
	char *mag_new(), *rec = mag_new("magic.mes"), buf[16];
	int N = mes_count(mes) - 1, i;

	db_put(rec, "dest", dest);
	db_numstore(rec, "N", N);
	for (i = 0; i < N; i++) {
		mag_strnum(buf, i);
		db_put(rec, buf, mes[i + 1]);
	}
	val_free(dest);
	mes_free(mes);
}

/* Initialization.  It calls all the appropriate initialization routines.
 */
mag_cold(name, width, height, mapped)
char *name;
{
	extern char *mag_me;
	char *wid;

	mag_me = name;
	db_init(name);
	db_store("control", "status", "run");
	db_store("datadict", "$number", "# $attr $db_datadict");
	db_store("datadict", "N", "# $db_ddcount");
	mag_picture("window", "widget", "window", width, height, mapped);
	wid = pic_new("widget", "bar", (char *) 0, 0, 0, 12, height, 1, 1);
	db_store(wid, "height", "#widget height #");
	MAG_FREE(wid);
	std_init();
	temp_init();
	edit_init();
	dump_init();
	quit_init();
	ww_init();
	calc_init();
	mag_menu();
}
