/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * Because of all kinds of time crap it's pretty hard to deduce what hour
 * it is given the number of seconds since the epoch.  This routine calls
 * ctime to figure it out.
 */

#include "magic.h"
#include "value.h"
#include "expr.h"
#include <X11/Xlib.h>
#include "win.h"

clk_hour(c)
struct context *c;
{
	struct value *x_pop(), *now = x_pop(c);
	long t;
	char *ctime(), *s;

	if (val_null(now))
		x_dirpush(now);
	else {
		t = val_int(now);
		s = ctime(&t);
		s[13] = 0;
		x_dirpush(val_cstr(s + 11, val_seq(now)));
		val_free(now);
	}
}

clk_register(){
	x_register("$local_hour", clk_hour);
}
